/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.unmarshaller;

import com.sun.istack.Nullable;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.impl.DatatypeConverterImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Messages;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.TagName;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.UnmarshallingContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XsiTypeLoader
extends Loader {
    private final JaxBeanInfo defaultBeanInfo;

    public XsiTypeLoader(JaxBeanInfo defaultBeanInfo) {
        super(true);
        this.defaultBeanInfo = defaultBeanInfo;
    }

    public void startElement(UnmarshallingContext.State state, TagName ea) throws SAXException {
        Loader loader;
        JaxBeanInfo beanInfo = XsiTypeLoader.parseXsiType(state, ea, this.defaultBeanInfo);
        if (beanInfo == null) {
            beanInfo = this.defaultBeanInfo;
        }
        state.loader = loader = beanInfo.getLoader(null, false);
        loader.startElement(state, ea);
    }

    static JaxBeanInfo parseXsiType(UnmarshallingContext.State state, TagName ea, @Nullable JaxBeanInfo defaultBeanInfo) throws SAXException {
        UnmarshallingContext context = state.getContext();
        JaxBeanInfo beanInfo = null;
        Attributes atts = ea.atts;
        int idx = atts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (idx >= 0) {
            String value = atts.getValue(idx);
            QName type = DatatypeConverterImpl._parseQName(value, context);
            if (type == null) {
                XsiTypeLoader.reportError(Messages.NOT_A_QNAME.format(value), true);
            } else {
                if (defaultBeanInfo != null && defaultBeanInfo.getTypeNames().contains(type)) {
                    return defaultBeanInfo;
                }
                beanInfo = context.getJAXBContext().getGlobalType(type);
                if (beanInfo == null) {
                    String nearest = context.getJAXBContext().getNearestTypeName(type);
                    if (nearest != null) {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME_MAYBE.format(type, nearest), true);
                    } else {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME.format(type), true);
                    }
                }
            }
        }
        return beanInfo;
    }
}

