/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.unmarshaller;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.UnmarshallingContext;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scope<BeanT, PropT, ItemT, PackT> {
    public final UnmarshallingContext context;
    private BeanT bean;
    private Accessor<BeanT, PropT> acc;
    private PackT pack;
    private Lister<BeanT, PropT, ItemT, PackT> lister;

    Scope(UnmarshallingContext context) {
        this.context = context;
    }

    public boolean hasStarted() {
        return this.bean != null;
    }

    public void reset() {
        if (this.bean == null) {
            assert (this.clean());
            return;
        }
        this.bean = null;
        this.acc = null;
        this.pack = null;
        this.lister = null;
    }

    public void finish() throws AccessorException {
        if (this.hasStarted()) {
            this.lister.endPacking(this.pack, this.bean, this.acc);
            this.reset();
        }
        assert (this.clean());
    }

    private boolean clean() {
        return this.bean == null && this.acc == null && this.pack == null && this.lister == null;
    }

    public void add(Accessor<BeanT, PropT> acc, Lister<BeanT, PropT, ItemT, PackT> lister, ItemT value) throws SAXException {
        try {
            if (!this.hasStarted()) {
                this.bean = this.context.getCurrentState().target;
                this.acc = acc;
                this.lister = lister;
                this.pack = lister.startPacking(this.bean, acc);
            }
            lister.addToPack(this.pack, value);
        }
        catch (AccessorException e) {
            Loader.handleGenericException(e, true);
            this.lister = Lister.getErrorInstance();
            this.acc = Accessor.getErrorInstance();
        }
    }

    public void start(Accessor<BeanT, PropT> acc, Lister<BeanT, PropT, ItemT, PackT> lister) throws SAXException {
        try {
            if (!this.hasStarted()) {
                this.bean = this.context.getCurrentState().target;
                this.acc = acc;
                this.lister = lister;
                this.pack = lister.startPacking(this.bean, acc);
            }
        }
        catch (AccessorException e) {
            Loader.handleGenericException(e, true);
            this.lister = Lister.getErrorInstance();
            this.acc = Accessor.getErrorInstance();
        }
    }
}

