/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.ClassFactory;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.core.WildcardMode;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElement;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeReferencePropertyInfo;
import org.jvnet.jaxb.reflection.runtime.ElementBeanInfoImpl;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.property.PropertyImpl;
import org.jvnet.jaxb.reflection.runtime.property.UnmarshallerChain;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ChildLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.WildcardLoader;
import org.jvnet.jaxb.reflection.util.QNameMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleReferenceNodeProperty<BeanT, ValueT>
extends PropertyImpl<BeanT> {
    private final Accessor<BeanT, ValueT> acc;
    private final QNameMap<JaxBeanInfo> expectedElements = new QNameMap();
    private final DomHandler domHandler;
    private final WildcardMode wcMode;

    public SingleReferenceNodeProperty(JAXBContextImpl context, RuntimeReferencePropertyInfo prop) {
        super(context, prop);
        this.acc = prop.getAccessor().optimize(context);
        for (RuntimeElement runtimeElement : prop.getElements()) {
            this.expectedElements.put(runtimeElement.getElementName(), context.getOrCreate(runtimeElement));
        }
        if (prop.getWildcard() != null) {
            this.domHandler = (DomHandler)ClassFactory.create((Class)prop.getDOMHandler());
            this.wcMode = prop.getWildcard();
        } else {
            this.domHandler = null;
            this.wcMode = null;
        }
    }

    @Override
    public void reset(BeanT bean) throws AccessorException {
        this.acc.set(bean, null);
    }

    @Override
    public String getIdValue(BeanT beanT) {
        return null;
    }

    @Override
    public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer) throws SAXException, AccessorException, IOException, XMLStreamException {
        ValueT v = this.acc.get(o);
        if (v != null) {
            try {
                JaxBeanInfo bi = w.grammar.getBeanInfo(v, true);
                if (bi.jaxbType == Object.class && this.domHandler != null) {
                    w.writeDom(v, this.domHandler, o, this.fieldName);
                } else {
                    bi.serializeRoot(v, w);
                }
            }
            catch (JAXBException e) {
                w.reportError(this.fieldName, e);
            }
        }
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers) {
        for (QNameMap.Entry<JaxBeanInfo> n : this.expectedElements.entrySet()) {
            handlers.put(n.nsUri, n.localName, new ChildLoader(n.getValue().getLoader(chain.context, true), this.acc));
        }
        if (this.domHandler != null) {
            handlers.put(CATCH_ALL, new ChildLoader(new WildcardLoader(this.domHandler, this.wcMode), this.acc));
        }
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.REFERENCE;
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        JaxBeanInfo bi = this.expectedElements.get(nsUri, localName);
        if (bi != null) {
            if (bi instanceof ElementBeanInfoImpl) {
                final ElementBeanInfoImpl ebi = (ElementBeanInfoImpl)bi;
                return new Accessor<BeanT, Object>(ebi.expectedType){

                    @Override
                    public Object get(BeanT bean) throws AccessorException {
                        Object r = SingleReferenceNodeProperty.this.acc.get(bean);
                        if (r instanceof JAXBElement) {
                            return ((JAXBElement)r).getValue();
                        }
                        return r;
                    }

                    @Override
                    public void set(BeanT bean, Object value) throws AccessorException {
                        if (value != null) {
                            try {
                                value = ebi.createInstanceFromValue(value);
                            }
                            catch (IllegalAccessException e) {
                                throw new AccessorException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new AccessorException(e);
                            }
                            catch (InstantiationException e) {
                                throw new AccessorException(e);
                            }
                        }
                        SingleReferenceNodeProperty.this.acc.set(bean, value);
                    }
                };
            }
            return this.acc;
        }
        return null;
    }
}

