/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.jvnet.jaxb.reflection.model.core.ID;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeAttributePropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElementPropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeNonElement;
import org.jvnet.jaxb.reflection.model.runtime.RuntimePropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeValuePropertyInfo;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.property.ArrayElementLeafProperty;
import org.jvnet.jaxb.reflection.runtime.property.ArrayElementNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ArrayReferenceNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.AttributeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ListElementProperty;
import org.jvnet.jaxb.reflection.runtime.property.Property;
import org.jvnet.jaxb.reflection.runtime.property.SingleElementLeafProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleElementNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleMapNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.SingleReferenceNodeProperty;
import org.jvnet.jaxb.reflection.runtime.property.ValueProperty;

public abstract class PropertyFactory {
    private static final Constructor<? extends Property>[] propImpls;

    private PropertyFactory() {
    }

    public static Property create(JAXBContextImpl grammar, RuntimePropertyInfo info) {
        PropertyKind kind = info.kind();
        switch (kind) {
            case ATTRIBUTE: {
                return new AttributeProperty(grammar, (RuntimeAttributePropertyInfo)info);
            }
            case VALUE: {
                return new ValueProperty(grammar, (RuntimeValuePropertyInfo)info);
            }
            case ELEMENT: {
                if (!((RuntimeElementPropertyInfo)info).isValueList()) break;
                return new ListElementProperty(grammar, (RuntimeElementPropertyInfo)info);
            }
            case REFERENCE: 
            case MAP: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean isCollection = info.isCollection();
        boolean isLeaf = PropertyFactory.isLeaf(info);
        Constructor<? extends Property> c = propImpls[(isLeaf ? 0 : 6) + (isCollection ? 3 : 0) + kind.propertyIndex];
        try {
            return c.newInstance(new Object[]{grammar, info});
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new AssertionError((Object)t);
        }
    }

    static boolean isLeaf(RuntimePropertyInfo info) {
        Collection<? extends RuntimeTypeInfo> types = info.ref();
        if (types.size() != 1) {
            return false;
        }
        RuntimeTypeInfo rti = types.iterator().next();
        if (!(rti instanceof RuntimeNonElement)) {
            return false;
        }
        if (info.id() == ID.IDREF) {
            return true;
        }
        if (((RuntimeNonElement)rti).getTransducer() == null) {
            return false;
        }
        return info.getIndividualType().equals(rti.getType());
    }

    static {
        Class[] implClasses = new Class[]{SingleElementLeafProperty.class, null, null, ArrayElementLeafProperty.class, null, null, SingleElementNodeProperty.class, SingleReferenceNodeProperty.class, SingleMapNodeProperty.class, ArrayElementNodeProperty.class, ArrayReferenceNodeProperty.class, null};
        propImpls = new Constructor[implClasses.length];
        for (int i = 0; i < propImpls.length; ++i) {
            if (implClasses[i] == null) continue;
            PropertyFactory.propImpls[i] = implClasses[i].getConstructors()[0];
        }
    }
}

