/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElementPropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeRef;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.Name;
import org.jvnet.jaxb.reflection.runtime.Transducer;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.property.ArrayProperty;
import org.jvnet.jaxb.reflection.runtime.property.UnmarshallerChain;
import org.jvnet.jaxb.reflection.runtime.reflect.ListTransducedAccessorImpl;
import org.jvnet.jaxb.reflection.runtime.reflect.TransducedAccessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ChildLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.LeafPropertyLoader;
import org.jvnet.jaxb.reflection.util.QNameMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListElementProperty<BeanT, ListT, ItemT>
extends ArrayProperty<BeanT, ListT, ItemT> {
    private final Name tagName;
    private final TransducedAccessor<BeanT> xacc;

    public ListElementProperty(JAXBContextImpl grammar, RuntimeElementPropertyInfo prop) {
        super(grammar, prop);
        assert (prop.isValueList());
        assert (prop.getTypes().size() == 1);
        RuntimeTypeRef ref = prop.getTypes().get(0);
        this.tagName = grammar.nameBuilder.createElementName(ref.getTagName());
        Transducer xducer = ref.getTransducer();
        this.xacc = new ListTransducedAccessorImpl(xducer, this.acc, this.lister);
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers) {
        handlers.put(this.tagName, new ChildLoader(new LeafPropertyLoader(this.xacc), null));
    }

    @Override
    public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer) throws SAXException, AccessorException, IOException, XMLStreamException {
        Object list = this.acc.get(o);
        if (list != null) {
            if (this.xacc.useNamespace()) {
                w.startElement(this.tagName, null);
                this.xacc.declareNamespace(o, w);
                w.endNamespaceDecls(list);
                w.endAttributes();
                this.xacc.writeText(w, o, this.fieldName);
                w.endElement();
            } else {
                this.xacc.writeLeafElement(w, this.tagName, o, this.fieldName);
            }
        }
    }
}

