/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.model.impl;

import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.TODO;
import org.jvnet.jaxb.reflection.model.annotation.Locatable;
import org.jvnet.jaxb.reflection.model.core.ArrayInfo;
import org.jvnet.jaxb.reflection.model.core.NonElement;
import org.jvnet.jaxb.reflection.model.impl.Messages;
import org.jvnet.jaxb.reflection.model.impl.ModelBuilder;
import org.jvnet.jaxb.reflection.model.impl.TypeInfoImpl;
import org.jvnet.jaxb.reflection.runtime.IllegalAnnotationException;
import org.jvnet.jaxb.reflection.runtime.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayInfoImpl<TypeT, ClassDeclT, FieldT, MethodT>
extends TypeInfoImpl<TypeT, ClassDeclT, FieldT, MethodT>
implements ArrayInfo<TypeT, ClassDeclT>,
Location {
    private final NonElement<TypeT, ClassDeclT> itemType;
    private final QName typeName;
    private final TypeT arrayType;

    public ArrayInfoImpl(ModelBuilder<TypeT, ClassDeclT, FieldT, MethodT> builder, Locatable upstream, TypeT arrayType) {
        super(builder, upstream);
        this.arrayType = arrayType;
        Object componentType = this.nav().getComponentType(arrayType);
        this.itemType = builder.getTypeInfo(componentType, this);
        QName n = this.itemType.getTypeName();
        if (n == null) {
            builder.reportError(new IllegalAnnotationException(Messages.ANONYMOUS_ARRAY_ITEM.format(this.nav().getTypeName(componentType)), this));
            n = new QName("#dummy");
        }
        this.typeName = ArrayInfoImpl.calcArrayTypeName(n);
    }

    public static QName calcArrayTypeName(QName n) {
        String uri;
        if (n.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            TODO.checkSpec("this URI");
            uri = "http://jaxb.dev.java.net/array";
        } else {
            uri = n.getNamespaceURI();
        }
        return new QName(uri, n.getLocalPart() + "Array");
    }

    @Override
    public NonElement<TypeT, ClassDeclT> getItemType() {
        return this.itemType;
    }

    @Override
    public QName getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public TypeT getType() {
        return this.arrayType;
    }

    @Override
    public final boolean canBeReferencedByIDREF() {
        return false;
    }

    @Override
    public Location getLocation() {
        return this;
    }

    @Override
    public String toString() {
        return this.nav().getTypeName(this.arrayType);
    }
}

