/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.impl.marshaller;

import java.io.IOException;
import java.io.Writer;
import org.jvnet.jaxb.reflection.impl.marshaller.CharacterEscapeHandler;

public class MinimumEscapeHandler
implements CharacterEscapeHandler {
    public static final CharacterEscapeHandler theInstance = new MinimumEscapeHandler();

    private MinimumEscapeHandler() {
    }

    public void escape(char[] ch, int start, int length, boolean isAttVal, Writer out) throws IOException {
        int limit = start + length;
        block6: for (int i = start; i < limit; ++i) {
            char c = ch[i];
            if (c != '&' && c != '<' && c != '>' && (c != '\"' || !isAttVal)) continue;
            if (i != start) {
                out.write(ch, start, i - start);
            }
            start = i + 1;
            switch (ch[i]) {
                case '&': {
                    out.write("&amp;");
                    continue block6;
                }
                case '<': {
                    out.write("&lt;");
                    continue block6;
                }
                case '>': {
                    out.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    out.write("&quot;");
                }
            }
        }
        if (start != limit) {
            out.write(ch, start, limit - start);
        }
    }
}

