/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.reflect;

import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrimitiveArrayListerDouble<BeanT>
extends Lister<BeanT, double[], Double, DoubleArrayPack> {
    private PrimitiveArrayListerDouble() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Double.TYPE, new PrimitiveArrayListerDouble());
    }

    @Override
    public ListIterator<Double> iterator(final double[] dArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Double>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < dArray.length;
            }

            @Override
            public Double next() {
                return dArray[this.idx++];
            }
        };
    }

    @Override
    public DoubleArrayPack startPacking(BeanT BeanT, Accessor<BeanT, double[]> accessor) {
        return new DoubleArrayPack();
    }

    @Override
    public void addToPack(DoubleArrayPack doubleArrayPack, Double d) {
        doubleArrayPack.add(d);
    }

    @Override
    public void endPacking(DoubleArrayPack doubleArrayPack, BeanT BeanT, Accessor<BeanT, double[]> accessor) throws AccessorException {
        accessor.set(BeanT, doubleArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, double[]> accessor) throws AccessorException {
        accessor.set(BeanT, new double[0]);
    }

    static final class DoubleArrayPack {
        double[] buf = new double[16];
        int size;

        DoubleArrayPack() {
        }

        void add(Double d) {
            if (this.buf.length == this.size) {
                double[] dArray = new double[this.buf.length * 2];
                System.arraycopy(this.buf, 0, dArray, 0, this.buf.length);
                this.buf = dArray;
            }
            this.buf[this.size++] = d;
        }

        double[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            double[] dArray = new double[this.size];
            System.arraycopy(this.buf, 0, dArray, 0, this.size);
            return dArray;
        }
    }
}

