/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElementPropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeRef;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.Name;
import org.jvnet.jaxb.reflection.runtime.Transducer;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.property.ArrayProperty;
import org.jvnet.jaxb.reflection.runtime.property.UnmarshallerChain;
import org.jvnet.jaxb.reflection.runtime.reflect.ListTransducedAccessorImpl;
import org.jvnet.jaxb.reflection.runtime.reflect.TransducedAccessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ChildLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.LeafPropertyLoader;
import org.jvnet.jaxb.reflection.util.QNameMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListElementProperty<BeanT, ListT, ItemT>
extends ArrayProperty<BeanT, ListT, ItemT> {
    private final Name tagName;
    private final TransducedAccessor<BeanT> xacc;

    public ListElementProperty(JAXBContextImpl jAXBContextImpl, RuntimeElementPropertyInfo runtimeElementPropertyInfo) {
        super(jAXBContextImpl, runtimeElementPropertyInfo);
        assert (runtimeElementPropertyInfo.isValueList());
        assert (runtimeElementPropertyInfo.getTypes().size() == 1);
        RuntimeTypeRef runtimeTypeRef = runtimeElementPropertyInfo.getTypes().get(0);
        this.tagName = jAXBContextImpl.nameBuilder.createElementName(runtimeTypeRef.getTagName());
        Transducer transducer = runtimeTypeRef.getTransducer();
        this.xacc = new ListTransducedAccessorImpl(transducer, this.acc, this.lister);
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain unmarshallerChain, QNameMap<ChildLoader> qNameMap) {
        qNameMap.put(this.tagName, new ChildLoader(new LeafPropertyLoader(this.xacc), null));
    }

    @Override
    public void serializeBody(BeanT BeanT, XMLSerializer xMLSerializer, Object object) throws SAXException, AccessorException, IOException, XMLStreamException {
        Object ValueT = this.acc.get(BeanT);
        if (ValueT != null) {
            if (this.xacc.useNamespace()) {
                xMLSerializer.startElement(this.tagName, null);
                this.xacc.declareNamespace(BeanT, xMLSerializer);
                xMLSerializer.endNamespaceDecls(ValueT);
                xMLSerializer.endAttributes();
                this.xacc.writeText(xMLSerializer, BeanT, this.fieldName);
                xMLSerializer.endElement();
            } else {
                this.xacc.writeLeafElement(xMLSerializer, this.tagName, BeanT, this.fieldName);
            }
        }
    }
}

