/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime.property;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.core.TypeRef;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeElementPropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeRef;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.Name;
import org.jvnet.jaxb.reflection.runtime.RuntimeUtil;
import org.jvnet.jaxb.reflection.runtime.Transducer;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.property.ArrayERProperty;
import org.jvnet.jaxb.reflection.runtime.property.PropertyFactory;
import org.jvnet.jaxb.reflection.runtime.property.TagAndType;
import org.jvnet.jaxb.reflection.runtime.property.UnmarshallerChain;
import org.jvnet.jaxb.reflection.runtime.reflect.Accessor;
import org.jvnet.jaxb.reflection.runtime.reflect.ListIterator;
import org.jvnet.jaxb.reflection.runtime.reflect.Lister;
import org.jvnet.jaxb.reflection.runtime.reflect.NullSafeAccessor;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.ChildLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.DefaultValueLoaderDecorator;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.TextLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.XsiNilLoader;
import org.jvnet.jaxb.reflection.util.QNameMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ArrayElementProperty<BeanT, ListT, ItemT>
extends ArrayERProperty<BeanT, ListT, ItemT> {
    private final Map<Class, TagAndType> typeMap = new HashMap<Class, TagAndType>();
    private Map<TypeRef<Type, Class>, JaxBeanInfo> refs = new HashMap<TypeRef<Type, Class>, JaxBeanInfo>();
    protected RuntimeElementPropertyInfo prop;
    private final Name nillableTagName;

    protected ArrayElementProperty(JAXBContextImpl jAXBContextImpl, RuntimeElementPropertyInfo runtimeElementPropertyInfo) {
        super(jAXBContextImpl, runtimeElementPropertyInfo, runtimeElementPropertyInfo.getXmlName(), runtimeElementPropertyInfo.isCollectionNillable());
        this.prop = runtimeElementPropertyInfo;
        List<? extends RuntimeTypeRef> list = runtimeElementPropertyInfo.getTypes();
        Name name = null;
        for (RuntimeTypeRef runtimeTypeRef : list) {
            Class clazz = (Class)runtimeTypeRef.getTarget().getType();
            if (clazz.isPrimitive()) {
                clazz = RuntimeUtil.primitiveToBox.get(clazz);
            }
            JaxBeanInfo jaxBeanInfo = jAXBContextImpl.getOrCreate(runtimeTypeRef.getTarget());
            TagAndType tagAndType = new TagAndType(jAXBContextImpl.nameBuilder.createElementName(runtimeTypeRef.getTagName()), jaxBeanInfo);
            this.typeMap.put(clazz, tagAndType);
            this.refs.put(runtimeTypeRef, jaxBeanInfo);
            if (!runtimeTypeRef.isNillable() || name != null) continue;
            name = tagAndType.tagName;
        }
        this.nillableTagName = name;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.refs = null;
        this.prop = null;
    }

    @Override
    protected void serializeListBody(BeanT BeanT, XMLSerializer xMLSerializer, ListT ListT) throws IOException, XMLStreamException, SAXException, AccessorException {
        ListIterator listIterator = this.lister.iterator(ListT, xMLSerializer);
        boolean bl = listIterator instanceof Lister.IDREFSIterator;
        while (listIterator.hasNext()) {
            try {
                Object ItemT = listIterator.next();
                if (ItemT != null) {
                    Class<?> clazz = ItemT.getClass();
                    if (bl) {
                        clazz = ((Lister.IDREFSIterator)listIterator).last().getClass();
                    }
                    TagAndType tagAndType = this.typeMap.get(clazz);
                    while (tagAndType == null && clazz != null) {
                        clazz = clazz.getSuperclass();
                        tagAndType = this.typeMap.get(clazz);
                    }
                    if (tagAndType == null) {
                        xMLSerializer.startElement(this.typeMap.values().iterator().next().tagName, null);
                        xMLSerializer.childAsXsiType(ItemT, this.fieldName, xMLSerializer.grammar.getBeanInfo(Object.class));
                    } else {
                        xMLSerializer.startElement(tagAndType.tagName, null);
                        this.serializeItem(tagAndType.beanInfo, ItemT, xMLSerializer);
                    }
                    xMLSerializer.endElement();
                    continue;
                }
                if (this.nillableTagName == null) continue;
                xMLSerializer.startElement(this.nillableTagName, null);
                xMLSerializer.writeXsiNilTrue();
                xMLSerializer.endElement();
            }
            catch (JAXBException jAXBException) {
                xMLSerializer.reportError(this.fieldName, jAXBException);
            }
        }
    }

    protected abstract void serializeItem(JaxBeanInfo var1, ItemT var2, XMLSerializer var3) throws SAXException, AccessorException, IOException, XMLStreamException;

    @Override
    public void createBodyUnmarshaller(UnmarshallerChain unmarshallerChain, QNameMap<ChildLoader> qNameMap) {
        int n = unmarshallerChain.allocateOffset();
        ArrayERProperty.ReceiverImpl receiverImpl = new ArrayERProperty.ReceiverImpl(n);
        for (RuntimeTypeRef runtimeTypeRef : this.prop.getTypes()) {
            Name name = unmarshallerChain.context.nameBuilder.createElementName(runtimeTypeRef.getTagName());
            Loader loader = this.createItemUnmarshaller(unmarshallerChain, runtimeTypeRef);
            if (runtimeTypeRef.isNillable() || unmarshallerChain.context.allNillable) {
                loader = new XsiNilLoader.Array(loader);
            }
            if (runtimeTypeRef.getDefaultValue() != null) {
                loader = new DefaultValueLoaderDecorator(loader, runtimeTypeRef.getDefaultValue());
            }
            qNameMap.put(name, new ChildLoader(loader, receiverImpl));
        }
    }

    @Override
    public final PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    private Loader createItemUnmarshaller(UnmarshallerChain unmarshallerChain, RuntimeTypeRef runtimeTypeRef) {
        if (PropertyFactory.isLeaf(runtimeTypeRef.getSource())) {
            Transducer transducer = runtimeTypeRef.getTransducer();
            return new TextLoader(transducer);
        }
        return this.refs.get(runtimeTypeRef).getLoader(unmarshallerChain.context, true);
    }

    @Override
    public Accessor getElementPropertyAccessor(String string, String string2) {
        if (this.wrapperTagName != null) {
            if (this.wrapperTagName.equals(string, string2)) {
                return this.acc;
            }
        } else {
            for (TagAndType tagAndType : this.typeMap.values()) {
                if (!tagAndType.tagName.equals(string, string2)) continue;
                return new NullSafeAccessor(this.acc, this.lister);
            }
        }
        return null;
    }
}

