/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.impl.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.model.nav.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeReference {
    public final QName tagName;
    public final Type type;
    public final Annotation[] annotations;

    public TypeReference(QName qName, Type type, Annotation ... annotationArray) {
        if (qName == null || type == null || annotationArray == null) {
            throw new IllegalArgumentException();
        }
        this.tagName = new QName(qName.getNamespaceURI().intern(), qName.getLocalPart().intern(), qName.getPrefix());
        this.type = type;
        this.annotations = annotationArray;
    }

    public <A extends Annotation> A get(Class<A> clazz) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != clazz) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    public TypeReference toItemType() {
        Type type = Navigator.REFLECTION.getBaseClass(this.type, Collection.class);
        if (type == null) {
            return this;
        }
        return new TypeReference(this.tagName, Navigator.REFLECTION.getTypeArgument(type, 0), new Annotation[0]);
    }
}

