/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.logging;

import java.util.logging.Logger;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;

public class LogModelProblemCollector
implements ModelProblemCollector {
    private static final Logger log = Logger.getLogger(LogModelProblemCollector.class.getName());
    private boolean hasSevereFailures = false;

    public void add(ModelProblem.Severity severity, String message, InputLocation location, Exception cause) {
        switch (severity) {
            case WARNING: {
                log.warning(message + ", caused by: " + cause.getMessage());
                break;
            }
            case ERROR: 
            case FATAL: {
                log.severe(message + ", caused by: " + cause.getMessage());
                this.hasSevereFailures = true;
            }
        }
    }

    public boolean hasSevereFailures() {
        return this.hasSevereFailures;
    }
}

