/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.io.File;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.SettingsXmlProfileSelector;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.jboss.shrinkwrap.resolver.impl.maven.task.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.task.Validate;

public class LoadPomMetadataTask
implements MavenWorkingSessionTask {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final File pomFile;
    private final String[] profiles;

    public LoadPomMetadataTask(File pomFile, String ... profiles) {
        Validate.notNull(pomFile, "POM file must be specified");
        this.pomFile = pomFile;
        this.profiles = profiles == null ? EMPTY_ARRAY : profiles;
    }

    public LoadPomMetadataTask(String pathToPomFile, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        Validate.notNullOrEmpty(pathToPomFile, "Path to a POM file must be specified");
        Validate.isReadable(pathToPomFile, "Path to the pom.xml ('" + pathToPomFile + "')file must be defined and accessible");
        this.pomFile = new File(pathToPomFile);
        this.profiles = profiles;
    }

    public MavenWorkingSession execute(MavenWorkingSession session) {
        Validate.notNull(this.pomFile, "Path to pom.xml file must not be null");
        Validate.isReadable(this.pomFile, "Path to the POM ('" + this.pomFile + "') file must be defined and accessible");
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setSystemProperties(SecurityActions.getProperties()).setProfiles(session.getSettingsDefinedProfiles()).setPomFile(this.pomFile).setActiveProfileIds(SettingsXmlProfileSelector.explicitlyActivatedProfiles(this.profiles)).setInactiveProfileIds(SettingsXmlProfileSelector.explicitlyDisabledProfiles(this.profiles));
        return session.execute((ModelBuildingRequest)request);
    }
}

