/**
 *
 *   Copyright 2013 sourceforge.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.gwtopenmaps.openlayers.client.protocol;

import org.gwtopenmaps.openlayers.client.format.Format;
import org.gwtopenmaps.openlayers.client.util.JSObject;
import org.gwtopenmaps.openlayers.client.util.JSObjectWrapper;


/**
 * ProtocolOptions base class
 *
 * @author davek<at>komacke<dot>com
 */
public class ProtocolOptions extends JSObjectWrapper
{

    protected ProtocolOptions(JSObject jsObject)
    {
        super(jsObject);
    }

    public ProtocolOptions()
    {
        this(JSObject.createJSObject());
    }

    public void setFormat(Format format)
    {
        getJSObject().setProperty("format", format.getJSObject());
    }

}
