/**
 *
 *   Copyright 2013 sourceforge.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.gwtopenmaps.openlayers.client;

/**
 * Map unit constants.
 * (not an Enum to stay java 1.4 compatible)
 *
 * The OpenLayers docs about map units:
 * Possible values are "degrees" (or "dd"), "m", "ft", "km", "mi", "inches".
 *
 * @author Edwin Commandeur - Atlis EJS
 */
public class MapUnits {

	public static final String DEGREES = "degrees";
	public static final String FEET = "ft";
	public static final String INCHES = "inch";
	public static final String KILOMETERS = "km";
	public static final String METERS = "m";
	public static final String MILES = "mi";

}
