/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class FormParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public FormParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.FORM);
    }

    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.isEmpty()) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new FormParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class FormParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;
        private static final Annotation encodedAnnotation = FormParamValueFactory.getEncodedAnnotation();

        FormParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object get(HttpContext context) {
            Form form = this.getCachedForm(context, this.decode);
            if (form == null) {
                Form otherForm = this.getCachedForm(context, !this.decode);
                if (otherForm != null) {
                    form = this.switchUrlEncoding(context, otherForm, this.decode);
                    this.cacheForm(context, form);
                } else {
                    form = this.getForm(context);
                    this.cacheForm(context, form);
                }
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)form.asMap());
            }
            catch (ExtractorException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }

        private Form switchUrlEncoding(HttpContext context, Form otherForm, boolean decode) {
            Set entries = otherForm.asMap().entrySet();
            Form newForm = new Form();
            for (Map.Entry entry : entries) {
                String charsetName = ReaderWriter.getCharset((MediaType)MediaType.valueOf((String)context.getRequestContext().getHeaderString("Content-Type"))).name();
                try {
                    String key = decode ? URLDecoder.decode((String)entry.getKey(), charsetName) : URLEncoder.encode((String)entry.getKey(), charsetName);
                    for (String value : (List)entry.getValue()) {
                        newForm.asMap().add((Object)key, (Object)(decode ? URLDecoder.decode(value, charsetName) : URLEncoder.encode(value, charsetName)));
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new ProcessingException(LocalizationMessages.ERROR_UNSUPPORTED_ENCODING(charsetName, this.extractor.getName()), (Throwable)uee);
                }
            }
            return newForm;
        }

        private void cacheForm(HttpContext context, Form form) {
            context.getRequestContext().setProperty(this.decode ? "jersey.config.server.representation.decoded.form" : "jersey.config.server.representation.form", form);
        }

        private Form getForm(HttpContext context) {
            return this.getFormParameters(this.ensureValidRequest(context.getRequestContext()));
        }

        private Form getCachedForm(HttpContext context, boolean decode) {
            return (Form)context.getRequestContext().getProperty(decode ? "jersey.config.server.representation.decoded.form" : "jersey.config.server.representation.form");
        }

        private ContainerRequest ensureValidRequest(ContainerRequest requestContext) throws IllegalStateException {
            if (requestContext.getMethod().equals("GET")) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_METHOD_ERROR());
            }
            if (!MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)requestContext.getMediaType())) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR());
            }
            return requestContext;
        }

        private static Annotation getEncodedAnnotation() {
            @Encoded
            final class EncodedAnnotationTemp {
                EncodedAnnotationTemp() {
                }
            }
            return EncodedAnnotationTemp.class.getAnnotation(Encoded.class);
        }

        private Form getFormParameters(ContainerRequest requestContext) {
            if (requestContext.getMediaType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                Form form;
                requestContext.bufferEntity();
                if (this.decode) {
                    form = requestContext.readEntity(Form.class);
                } else {
                    Annotation[] annotations = new Annotation[]{encodedAnnotation};
                    form = requestContext.readEntity(Form.class, annotations);
                }
                return form == null ? new Form() : form;
            }
            return new Form();
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<FormParam> {
        public InjectionResolver() {
            super(FormParamValueFactoryProvider.class);
        }
    }
}

