/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.BroadcasterListener;
import org.glassfish.jersey.server.ChunkedOutput;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class Broadcaster<T>
implements BroadcasterListener<T> {
    private final ConcurrentSkipListSet<BroadcasterListener<T>> listeners = new ConcurrentSkipListSet(new Comparator<BroadcasterListener<T>>(){

        @Override
        public int compare(BroadcasterListener<T> listener1, BroadcasterListener<T> listener2) {
            return listener1.hashCode() - listener2.hashCode();
        }
    });
    private final ConcurrentSkipListSet<ChunkedOutput<T>> chunkedOutputs = new ConcurrentSkipListSet(new Comparator<ChunkedOutput<T>>(){

        @Override
        public int compare(ChunkedOutput<T> chunkedOutput1, ChunkedOutput<T> chunkedOutput2) {
            return chunkedOutput1.hashCode() - chunkedOutput2.hashCode();
        }
    });

    public Broadcaster() {
        this(Broadcaster.class);
    }

    protected Broadcaster(Class<? extends Broadcaster> subclass) {
        if (subclass != this.getClass()) {
            this.listeners.add(this);
        }
    }

    public final boolean add(ChunkedOutput<T> chunkedOutput) {
        return this.chunkedOutputs.add(chunkedOutput);
    }

    public final boolean remove(ChunkedOutput<T> chunkedOutput) {
        return this.chunkedOutputs.remove(chunkedOutput);
    }

    public final boolean addBroadcasterListener(BroadcasterListener<T> listener) {
        return this.listeners.add(listener);
    }

    public final boolean removeBroadcasterListener(BroadcasterListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public void broadcast(final T chunk) {
        this.forEachChunkedResponse(new Task<ChunkedOutput<T>>(){

            @Override
            public void run(ChunkedOutput<T> cr) throws IOException {
                cr.write(chunk);
            }
        });
    }

    public void closeAll() {
        this.forEachChunkedResponse(new Task<ChunkedOutput<T>>(){

            @Override
            public void run(ChunkedOutput<T> cr) throws IOException {
                cr.close();
            }
        });
    }

    @Override
    public void onException(ChunkedOutput<T> chunkedOutput, Exception exception) {
    }

    @Override
    public void onClose(ChunkedOutput<T> chunkedOutput) {
    }

    private void forEachChunkedResponse(Task<ChunkedOutput<T>> t) {
        Iterator<ChunkedOutput<T>> iterator = this.chunkedOutputs.iterator();
        while (iterator.hasNext()) {
            ChunkedOutput<T> chunkedOutput = iterator.next();
            if (!chunkedOutput.isClosed()) {
                try {
                    t.run(chunkedOutput);
                }
                catch (Exception e) {
                    this.fireOnException(chunkedOutput, e);
                }
            }
            if (!chunkedOutput.isClosed()) continue;
            iterator.remove();
            this.fireOnClose(chunkedOutput);
        }
    }

    private void forEachListener(Task<BroadcasterListener<T>> t) {
        for (BroadcasterListener<T> listener : this.listeners) {
            try {
                t.run(listener);
            }
            catch (Exception e) {
                Logger.getLogger(Broadcaster.class.getName()).log(Level.WARNING, LocalizationMessages.BROADCASTER_LISTENER_EXCEPTION(e.getClass().getSimpleName()), e);
            }
        }
    }

    private void fireOnException(final ChunkedOutput<T> chunkedOutput, final Exception exception) {
        this.forEachListener(new Task<BroadcasterListener<T>>(){

            @Override
            public void run(BroadcasterListener<T> parameter) throws IOException {
                parameter.onException(chunkedOutput, exception);
            }
        });
    }

    private void fireOnClose(final ChunkedOutput<T> chunkedOutput) {
        this.forEachListener(new Task<BroadcasterListener<T>>(){

            @Override
            public void run(BroadcasterListener<T> parameter) throws IOException {
                parameter.onClose(chunkedOutput);
            }
        });
    }

    private static interface Task<T> {
        public void run(T var1) throws IOException;
    }
}

