/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;

public class ModelProcessorUtil {
    public static Set<String> getAllowedMethods(RuntimeResource resource) {
        HashSet allowedMethods = Sets.newHashSet();
        for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
            String httpMethod = resourceMethod.getHttpMethod();
            allowedMethods.add(httpMethod);
        }
        allowedMethods.add("OPTIONS");
        allowedMethods.add("HEAD");
        return allowedMethods;
    }

    private static boolean isMethodOverriden(ResourceMethod resourceMethod, String httpMethod, MediaType consumes, MediaType produces) {
        if (!resourceMethod.getHttpMethod().equals(httpMethod)) {
            return false;
        }
        boolean consumesMatch = ModelProcessorUtil.overrides(resourceMethod.getConsumedTypes(), consumes);
        boolean producesMatch = ModelProcessorUtil.overrides(resourceMethod.getProducedTypes(), produces);
        return consumesMatch && producesMatch;
    }

    private static boolean overrides(List<MediaType> mediaTypes, MediaType mediaType) {
        if (mediaTypes.isEmpty()) {
            return true;
        }
        for (MediaType mt : mediaTypes) {
            if (!ModelProcessorUtil.overrides(mt, mediaType)) continue;
            return true;
        }
        return false;
    }

    private static boolean overrides(MediaType mt1, MediaType mt2) {
        return mt1.isWildcardType() || mt1.getType().equals(mt2.getType()) && (mt1.isWildcardSubtype() || mt1.getSubtype().equals(mt2.getSubtype()));
    }

    public static ResourceModel.Builder enhanceResourceModel(ResourceModel resourceModel, boolean subResourceModel, List<Method> methods) {
        ResourceModel.Builder newModelBuilder = new ResourceModel.Builder(resourceModel, subResourceModel);
        for (RuntimeResource resource : resourceModel.getRuntimeResourceModel().getRuntimeResources()) {
            ModelProcessorUtil.enhanceResource(resource, newModelBuilder, methods);
        }
        return newModelBuilder;
    }

    private static void enhanceResource(RuntimeResource resource, ResourceModel.Builder newModelBuilder, List<Method> methods) {
        if (resource.getResourceMethods().size() > 0) {
            for (Method method : methods) {
                boolean found = false;
                for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                    if (!ModelProcessorUtil.isMethodOverriden(resourceMethod, method.httpMethod, method.consumes, method.produces)) continue;
                    found = true;
                }
                if (found) continue;
                Resource firstResource = resource.getResources().get(0);
                Resource.Builder resourceBuilder = Resource.builder(firstResource.getPath());
                resourceBuilder.addMethod(method.httpMethod).consumes(method.consumes).produces(method.produces).handledBy(method.inflector).build();
                Resource newResource = resourceBuilder.build();
                Resource parentResource = resource.getParentResources().get(0);
                if (parentResource != null) {
                    Resource.Builder parentBuilder = Resource.builder(parentResource.getPath());
                    parentBuilder.addChildResource(newResource);
                    newModelBuilder.addResource(parentBuilder.build());
                    continue;
                }
                newModelBuilder.addResource(newResource);
            }
        }
        for (RuntimeResource child : resource.getChildRuntimeResources()) {
            ModelProcessorUtil.enhanceResource(child, newModelBuilder, methods);
        }
    }

    public static class Method {
        private final String httpMethod;
        private final MediaType consumes;
        private final MediaType produces;
        private final Class<? extends Inflector<ContainerRequestContext, Response>> inflector;

        public Method(String httpMethod, MediaType consumes, MediaType produces, Class<? extends Inflector<ContainerRequestContext, Response>> inflector) {
            this.httpMethod = httpMethod;
            this.consumes = consumes;
            this.produces = produces;
            this.inflector = inflector;
        }
    }
}

