/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.Producer;

public class Errors {
    private static final Logger LOGGER = Logger.getLogger(Errors.class.getName());
    private static final ThreadLocal<Errors> errors = new ThreadLocal();
    private final ArrayList<ErrorMessage> issues = new ArrayList(0);
    private int mark = -1;
    private int stack = 0;

    public static void error(String message, boolean isFatal) {
        Errors.error(null, message, isFatal);
    }

    public static void error(Object source, String message, boolean isFatal) {
        Errors.getInstance().issues.add(new ErrorMessage(source, message, isFatal));
    }

    public static void fatal(Object source, String message) {
        Errors.error(source, message, true);
    }

    public static void warning(Object source, String message) {
        Errors.error(source, message, false);
    }

    private static List<ErrorMessage> processErrors(boolean throwException) {
        ArrayList<ErrorMessage> messages = new ArrayList<ErrorMessage>(Errors.errors.get().issues);
        boolean isFatal = false;
        if (!messages.isEmpty()) {
            StringBuilder errors = new StringBuilder("\n");
            StringBuilder warnings = new StringBuilder();
            for (ErrorMessage issue : messages) {
                if (issue.isFatal()) {
                    isFatal = true;
                    errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                    continue;
                }
                warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
            }
            if (isFatal) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED(errors.append((CharSequence)warnings).toString()));
                if (throwException) {
                    throw new ErrorMessagesException(messages);
                }
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED(warnings.toString()));
            }
        }
        return messages;
    }

    public static boolean fatalIssuesFound() {
        for (ErrorMessage message : Errors.getInstance().issues) {
            if (!message.isFatal()) continue;
            return true;
        }
        return false;
    }

    public static <T> T process(Producer<T> producer) {
        return Errors.process(producer, false);
    }

    public static <T> T processWithException(Producer<T> producer) {
        return Errors.process(producer, true);
    }

    public static void process(final Runnable task) {
        Errors.process(new Producer<Void>(){

            @Override
            public Void call() {
                task.run();
                return null;
            }
        }, false);
    }

    public static void processWithException(final Runnable task) {
        Errors.process(new Producer<Void>(){

            @Override
            public Void call() {
                task.run();
                return null;
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T process(Producer<T> producer, boolean throwException) {
        T t;
        Errors instance = errors.get();
        if (instance == null) {
            instance = new Errors();
            errors.set(instance);
        }
        instance.preProcess();
        RuntimeException caught = null;
        try {
            t = producer.call();
            instance.postProcess(throwException && caught == null);
        }
        catch (RuntimeException re) {
            try {
                caught = re;
                instance.postProcess(throwException && caught == null);
            }
            catch (Throwable throwable) {
                instance.postProcess(throwException && caught == null);
                throw throwable;
            }
        }
        return t;
        throw caught;
    }

    private static Errors getInstance() {
        Errors instance = errors.get();
        if (instance == null) {
            throw new IllegalStateException(LocalizationMessages.NO_ERROR_PROCESSING_IN_SCOPE());
        }
        if (instance.stack == 0) {
            errors.remove();
            throw new IllegalStateException(LocalizationMessages.NO_ERROR_PROCESSING_IN_SCOPE());
        }
        return instance;
    }

    public static List<ErrorMessage> getErrorMessages() {
        return Errors.getErrorMessages(false);
    }

    public static List<ErrorMessage> getErrorMessages(boolean afterMark) {
        return Errors.getInstance()._getErrorMessages(afterMark);
    }

    public static void mark() {
        Errors.getInstance()._mark();
    }

    public static void unmark() {
        Errors.getInstance()._unmark();
    }

    public static void reset() {
        Errors.getInstance()._reset();
    }

    private Errors() {
    }

    private void _mark() {
        this.mark = this.issues.size();
    }

    private void _unmark() {
        this.mark = -1;
    }

    private void _reset() {
        if (this.mark >= 0 && this.mark < this.issues.size()) {
            this.issues.subList(this.mark, this.issues.size()).clear();
            this._unmark();
        }
    }

    private void preProcess() {
        ++this.stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcess(boolean throwException) {
        --this.stack;
        if (this.stack == 0) {
            try {
                if (!this.issues.isEmpty()) {
                    Errors.processErrors(throwException);
                }
            }
            finally {
                errors.remove();
            }
        }
    }

    private List<ErrorMessage> _getErrorMessages(boolean afterMark) {
        if (afterMark && this.mark >= 0 && this.mark < this.issues.size()) {
            return Collections.unmodifiableList(new ArrayList<ErrorMessage>(this.issues.subList(this.mark, this.issues.size())));
        }
        return Collections.unmodifiableList(new ArrayList<ErrorMessage>(this.issues));
    }

    public static class ErrorMessage {
        private final Object source;
        private final String message;
        private final boolean isFatal;

        private ErrorMessage(Object source, String message, boolean isFatal) {
            this.source = source;
            this.message = message;
            this.isFatal = isFatal;
        }

        public boolean isFatal() {
            return this.isFatal;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getSource() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorMessage that = (ErrorMessage)o;
            if (this.isFatal != that.isFatal) {
                return false;
            }
            if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
                return false;
            }
            return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.isFatal ? 1 : 0);
            return result;
        }
    }

    public static class ErrorMessagesException
    extends RuntimeException {
        private final List<ErrorMessage> messages;

        private ErrorMessagesException(List<ErrorMessage> messages) {
            this.messages = messages;
        }

        public List<ErrorMessage> getMessages() {
            return this.messages;
        }
    }
}

