/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;

public final class Ascii {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];
    static final char[] digits;

    public static int toUpper(int c) {
        return toUpper[c & 0xFF] & 0xFF;
    }

    public static int toLower(int c) {
        return toLower[c & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int c) {
        return isAlpha[c & 0xFF];
    }

    public static boolean isUpper(int c) {
        return isUpper[c & 0xFF];
    }

    public static boolean isLower(int c) {
        return isLower[c & 0xFF];
    }

    public static boolean isWhite(int c) {
        return isWhite[c & 0xFF];
    }

    public static boolean isDigit(int c) {
        return isDigit[c & 0xFF];
    }

    public static int parseInt(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static int parseInt(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static int parseInt(Buffer b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b.get(off++))) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b.get(off++))) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static long parseLong(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long parseLong(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long parseLong(String s, int off, int len) throws NumberFormatException {
        char c;
        if (s == null || len <= 0 || !Ascii.isDigit(c = s.charAt(off++))) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = s.charAt(off++))) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long parseLong(Buffer b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b.get(off++))) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b.get(off++))) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long parseLong(DataChunk dataChunk) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc = dataChunk.getBufferChunk();
                return Ascii.parseLong(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            case String: {
                return Long.parseLong(dataChunk.toString());
            }
            case Chars: {
                CharChunk cc = dataChunk.getCharChunk();
                return Ascii.parseLong(cc.getBuffer(), cc.getStart(), cc.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static long parseLong(DataChunk dataChunk, int offset, int length) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc = dataChunk.getBufferChunk();
                return Ascii.parseLong(bc.getBuffer(), bc.getStart() + offset, length);
            }
            case String: {
                return Ascii.parseLong(dataChunk.toString(), offset, length);
            }
            case Chars: {
                CharChunk cc = dataChunk.getCharChunk();
                return Ascii.parseLong(cc.getBuffer(), cc.getStart() + offset, cc.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static void intToHexString(Buffer buffer, int i) {
        Ascii.intToUnsignedString(buffer, i, 4);
    }

    public static void intToUnsignedString(Buffer buffer, int value, int shift) {
        if (value == 0) {
            buffer.put((byte)48);
            return;
        }
        int currentShift = 32 - shift;
        int radix = 1 << shift;
        int mask = radix - 1 << currentShift;
        boolean initialZeros = true;
        while (mask != 0) {
            int digit = (value & mask) >>> currentShift;
            if (digit != 0 || !initialZeros) {
                buffer.put((byte)digits[digit]);
                initialZeros = false;
            }
            mask >>>= shift;
            currentShift -= shift;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Ascii.toUpper[i] = (byte)i;
            Ascii.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Ascii.toUpper[lc] = (byte)uc;
            Ascii.toLower[uc] = (byte)lc;
            Ascii.isAlpha[lc] = true;
            Ascii.isAlpha[uc] = true;
            Ascii.isLower[lc] = true;
            Ascii.isUpper[uc] = true;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        for (int d = 48; d <= 57; ++d) {
            Ascii.isDigit[d] = true;
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    }
}

