/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpContent;

public final class ParsingResult
implements Cacheable {
    private static final ThreadCache.CachedTypeIndex<ParsingResult> CACHE_IDX = ThreadCache.obtainIndex(ParsingResult.class, (int)1);
    private HttpContent httpContent;
    private Buffer remainderBuffer;

    public static ParsingResult create(HttpContent httpContent, Buffer remainderBuffer) {
        ParsingResult resultObject = (ParsingResult)ThreadCache.takeFromCache(CACHE_IDX);
        if (resultObject == null) {
            resultObject = new ParsingResult();
        }
        resultObject.httpContent = httpContent;
        resultObject.remainderBuffer = remainderBuffer;
        return resultObject;
    }

    private ParsingResult() {
    }

    public Buffer getRemainderBuffer() {
        return this.remainderBuffer;
    }

    public HttpContent getHttpContent() {
        return this.httpContent;
    }

    public void recycle() {
        this.remainderBuffer = null;
        this.httpContent = null;
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }
}

