/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.ProcessingState;

class HttpRequestPacketImpl
extends HttpRequestPacket
implements HttpPacketParsing {
    private static final ThreadCache.CachedTypeIndex<HttpRequestPacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpRequestPacketImpl.class, (int)16);
    private boolean isHeaderParsed;
    private final HttpCodecFilter.HeaderParsingState headerParsingState = new HttpCodecFilter.HeaderParsingState();
    private final HttpCodecFilter.ContentParsingState contentParsingState = new HttpCodecFilter.ContentParsingState();
    private final ProcessingState processingState = new ProcessingState();

    public static HttpRequestPacketImpl create() {
        HttpRequestPacketImpl httpRequestImpl = (HttpRequestPacketImpl)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpRequestImpl != null) {
            return httpRequestImpl;
        }
        return new HttpRequestPacketImpl();
    }

    private HttpRequestPacketImpl() {
        this.isExpectContent = true;
    }

    public void initialize(Connection connection, HttpCodecFilter filter, int initialOffset, int maxHeaderSize) {
        this.headerParsingState.initialize(filter, initialOffset, maxHeaderSize);
        this.setConnection(connection);
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    public HttpCodecFilter.HeaderParsingState getHeaderParsingState() {
        return this.headerParsingState;
    }

    @Override
    public HttpCodecFilter.ContentParsingState getContentParsingState() {
        return this.contentParsingState;
    }

    @Override
    public boolean isHeaderParsed() {
        return this.isHeaderParsed;
    }

    @Override
    public void setHeaderParsed(boolean isHeaderParsed) {
        if (isHeaderParsed && !this.isChunked) {
            this.contentParsingState.chunkRemainder = this.getContentLength();
        }
        this.isHeaderParsed = isHeaderParsed;
    }

    @Override
    protected void reset() {
        this.headerParsingState.recycle();
        this.contentParsingState.recycle();
        this.processingState.recycle();
        this.isHeaderParsed = false;
        this.isExpectContent = true;
        super.reset();
    }

    @Override
    public void recycle() {
        if (this.isExpectContent()) {
            return;
        }
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }
}

