/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.jmx;

import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

@ManagedObject
@Description(value="The NetworkListener is an abstraction around the Transport (exposed as a child of this entity).")
public class NetworkListener
extends JmxObject {
    private final org.glassfish.grizzly.http.server.NetworkListener listener;
    private FileCache currentFileCache;
    private Transport currentTransport;
    private KeepAlive currentKeepAlive;
    private JmxObject fileCacheJmx;
    private JmxObject transportJmx;
    private JmxObject keepAliveJmx;
    private HttpServerFilter currentHttpServerFilter;
    private JmxObject webServerFilterJmx;
    private HttpCodecFilter currentHttpCodecFilter;
    private JmxObject httpCodecFilterJmx;
    private GrizzlyJmxManager mom;

    public NetworkListener(org.glassfish.grizzly.http.server.NetworkListener listener) {
        this.listener = listener;
    }

    public String getJmxName() {
        return "NetworkListener";
    }

    protected synchronized void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.mom = mom;
        this.rebuildSubTree();
    }

    protected synchronized void onDeregister(GrizzlyJmxManager mom) {
        this.mom = null;
    }

    @ManagedAttribute(id="name")
    @Description(value="The logical name of the listener.")
    public String getName() {
        return this.listener.getName();
    }

    @ManagedAttribute(id="host")
    @Description(value="The network host to which this listener is bound.")
    public String getHost() {
        return this.listener.getHost();
    }

    @ManagedAttribute(id="port")
    @Description(value="The network port to which this listener is bound.")
    public int getPort() {
        return this.listener.getPort();
    }

    @ManagedAttribute(id="idle-timeout-in-seconds")
    @Description(value="The time, in seconds, to keep an inactive request alive.")
    public int getIdleTimeoutInSeconds() {
        return this.listener.getKeepAlive().getIdleTimeoutInSeconds();
    }

    @ManagedAttribute(id="secure")
    @Description(value="Indicates whether or not this listener is secured via SSL.")
    public boolean isSecure() {
        return this.listener.isSecure();
    }

    @ManagedAttribute(id="max-http-header-size")
    @Description(value="The maximum size, in bytes, an HTTP request may be.")
    public int getMaxHttpHeaderSize() {
        return this.listener.getMaxHttpHeaderSize();
    }

    @ManagedAttribute(id="max-pending-bytes")
    @Description(value="The maximum size, in bytes, a connection may have waiting to be sent to the client.")
    public int getMaxPendingBytes() {
        return this.listener.getMaxPendingBytes();
    }

    @ManagedAttribute(id="chunking-enabled")
    @Description(value="Flag indicating whether or not the http response body will be sent using the chunked transfer encoding.")
    public boolean isChunkingEnabled() {
        return this.listener.isChunkingEnabled();
    }

    @ManagedAttribute(id="started")
    @Description(value="Indicates whether or not this listener is started.")
    public boolean isStarted() {
        return this.listener.isStarted();
    }

    @Description(value="Indicates whether or not a started listener is actively processing requests.")
    @ManagedAttribute(id="paused")
    public boolean isPaused() {
        return this.listener.isPaused();
    }

    protected void rebuildSubTree() {
        HttpCodecFilter codecFilter;
        HttpServerFilter filter;
        KeepAlive keepAlive;
        TCPNIOTransport transport;
        FileCache fileCache = this.listener.getFileCache();
        if (this.currentFileCache != fileCache) {
            if (this.currentFileCache != null) {
                this.mom.deregister(this.fileCacheJmx);
                this.currentFileCache = null;
                this.fileCacheJmx = null;
            }
            if (fileCache != null) {
                JmxObject jmx = fileCache.getMonitoringConfig().createManagementObject();
                this.mom.register((Object)this, jmx, jmx.getJmxName());
                this.currentFileCache = fileCache;
                this.fileCacheJmx = jmx;
            }
        }
        if (this.currentTransport != (transport = this.listener.getTransport())) {
            if (this.currentTransport != null) {
                this.mom.deregister(this.transportJmx);
                this.currentTransport = null;
                this.transportJmx = null;
            }
            if (transport != null) {
                JmxObject jmx = transport.getMonitoringConfig().createManagementObject();
                this.mom.register((Object)this, jmx, jmx.getJmxName());
                this.currentTransport = transport;
                this.transportJmx = jmx;
            }
        }
        if (this.currentKeepAlive != (keepAlive = this.listener.getKeepAlive())) {
            if (this.currentKeepAlive != null) {
                this.mom.deregister(this.keepAliveJmx);
                this.currentKeepAlive = null;
                this.keepAliveJmx = null;
            }
            if (transport != null) {
                JmxObject jmx = keepAlive.getMonitoringConfig().createManagementObject();
                this.mom.register((Object)this, jmx, jmx.getJmxName());
                this.currentKeepAlive = keepAlive;
                this.keepAliveJmx = jmx;
            }
        }
        if (this.currentHttpServerFilter != (filter = this.listener.getHttpServerFilter())) {
            if (this.currentHttpServerFilter != null) {
                this.mom.deregister(this.webServerFilterJmx);
                this.currentHttpServerFilter = null;
                this.webServerFilterJmx = null;
            }
            if (filter != null) {
                JmxObject jmx = filter.getMonitoringConfig().createManagementObject();
                this.mom.register((Object)this, jmx, jmx.getJmxName());
                this.currentHttpServerFilter = filter;
                this.webServerFilterJmx = jmx;
            }
        }
        if (this.currentHttpCodecFilter != (codecFilter = this.listener.getHttpCodecFilter())) {
            if (this.currentHttpCodecFilter != null) {
                this.mom.deregister(this.httpCodecFilterJmx);
                this.currentHttpCodecFilter = null;
                this.httpCodecFilterJmx = null;
            }
            if (codecFilter != null) {
                JmxObject jmx = codecFilter.getMonitoringConfig().createManagementObject();
                this.mom.register((Object)this, jmx, jmx.getJmxName());
                this.currentHttpCodecFilter = codecFilter;
                this.httpCodecFilterJmx = jmx;
            }
        }
    }
}

