/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.server.io.WriteHandler;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.utils.Exceptions;

public class OutputBuffer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private HttpResponsePacket response;
    private FilterChainContext ctx;
    private CompositeBuffer compositeBuffer;
    private Buffer currentBuffer;
    private boolean committed;
    private boolean finished;
    private boolean closed;
    private boolean processingChars;
    private CharsetEncoder encoder;
    private final CharBuffer charBuf = CharBuffer.allocate(1);
    private MemoryManager memoryManager;
    private WriteHandler handler;
    private final AtomicReference<Throwable> asyncError = new AtomicReference();
    private TaskQueue.QueueMonitor monitor;
    private AsyncQueueWriter asyncWriter;
    private int bufferSize = 8192;
    private final CompletionHandler<WriteResult> asyncCompletionHandler = new EmptyCompletionHandler<WriteResult>(){

        public void failed(Throwable throwable) {
            if (OutputBuffer.this.handler != null) {
                OutputBuffer.this.handler.onError(throwable);
            } else {
                OutputBuffer.this.asyncError.compareAndSet(null, throwable);
            }
        }
    };

    public void initialize(HttpResponsePacket response, FilterChainContext ctx) {
        this.response = response;
        this.ctx = ctx;
        this.memoryManager = ctx.getMemoryManager();
        this.compositeBuffer = this.createCompositeBuffer();
        Connection c = ctx.getConnection();
        this.asyncWriter = (AsyncQueueWriter)c.getTransport().getWriter(c);
        if (this.asyncWriter.getMaxPendingBytesPerConnection() <= 0) {
            this.asyncWriter = null;
        }
    }

    public void processingChars() {
        this.processingChars = true;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (!this.committed && this.currentBuffer == null) {
            this.bufferSize = bufferSize;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        if (this.compositeBuffer != null) {
            this.compositeBuffer.removeAll();
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.clear();
        }
    }

    public void recycle() {
        this.response = null;
        if (this.compositeBuffer != null) {
            this.compositeBuffer.dispose();
            this.compositeBuffer = null;
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.dispose();
            this.currentBuffer = null;
        }
        this.charBuf.position(0);
        this.encoder = null;
        this.ctx = null;
        this.memoryManager = null;
        this.handler = null;
        this.asyncError.set(null);
        this.monitor = null;
        this.asyncWriter = null;
        this.committed = false;
        this.finished = false;
        this.closed = false;
        this.processingChars = false;
    }

    public void endRequest() throws IOException {
        this.handleAsyncErrors();
        if (this.finished) {
            return;
        }
        if (this.monitor != null) {
            Connection c = this.ctx.getConnection();
            TaskQueue tqueue = ((NIOConnection)c).getAsyncWriteQueue();
            tqueue.removeQueueMonitor(this.monitor);
            this.monitor = null;
        }
        if (!this.closed) {
            this.close();
        }
        if (this.ctx != null) {
            this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        }
        this.finished = true;
    }

    public void acknowledge() throws IOException {
        this.ctx.write((Object)this.response);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.flushCharsToBuf(CharBuffer.wrap(cbuf, off, len));
    }

    public void writeChar(int c) throws IOException {
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.charBuf.position(0);
        this.charBuf.put(0, (char)c);
        this.flushCharsToBuf(this.charBuf);
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.flushCharsToBuf(CharBuffer.wrap(str, off, len + off));
    }

    public void writeByte(int b) throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.checkCurrentBuffer();
        if (this.currentBuffer.hasRemaining()) {
            this.currentBuffer.put((byte)b);
        } else {
            this.flush();
            this.checkCurrentBuffer();
            this.currentBuffer.put((byte)b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        int total = len;
        do {
            this.checkCurrentBuffer();
            int writeLen = Math.min(this.currentBuffer.remaining(), total);
            this.currentBuffer.put(b, off, writeLen);
            off += writeLen;
            total -= writeLen;
            if (this.currentBuffer.hasRemaining()) {
                return;
            }
            this.flush();
        } while (total > 0);
    }

    public void close() throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean isJustCommitted = this.doCommit();
        if (!this.writeContentChunk(!isJustCommitted, true) && (isJustCommitted || this.response.isChunked())) {
            this.forceCommitHeaders(true);
        }
    }

    public void flush() throws IOException {
        boolean isJustCommitted = this.doCommit();
        if (!this.writeContentChunk(!isJustCommitted, false) && isJustCommitted) {
            this.forceCommitHeaders(false);
        }
    }

    public void writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Buffer w = Buffers.wrap((MemoryManager)this.memoryManager, (ByteBuffer)byteBuffer);
        w.allowBufferDispose(false);
        this.writeBuffer(w);
    }

    public void writeBuffer(Buffer buffer) throws IOException {
        this.handleAsyncErrors();
        this.finishCurrentBuffer();
        this.compositeBuffer.append((Object)buffer);
    }

    public boolean canWriteChar(int length) {
        if (length <= 0 || this.asyncWriter == null) {
            return true;
        }
        CharsetEncoder e = this.getEncoder();
        int len = Float.valueOf((float)length * e.averageBytesPerChar()).intValue();
        return this.canWrite(len);
    }

    public boolean canWrite(int length) {
        if (length <= 0 || this.asyncWriter == null) {
            return true;
        }
        Connection c = this.ctx.getConnection();
        return this.asyncWriter.canWrite(c, length);
    }

    public void notifyCanWrite(final WriteHandler handler, final int length) {
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to set a new handler before the existing handler has been notified.");
        }
        if (this.asyncWriter == null || this.canWrite(length)) {
            try {
                handler.onWritePossible();
            }
            catch (Exception ioe) {
                handler.onError(ioe);
            }
            return;
        }
        this.handler = handler;
        Connection c = this.ctx.getConnection();
        final TaskQueue taskQueue = ((NIOConnection)c).getAsyncWriteQueue();
        final int maxBytes = this.asyncWriter.getMaxPendingBytesPerConnection();
        if (length > maxBytes) {
            throw new IllegalArgumentException("Illegal request to write " + length + " bytes.  Max allowable write is " + maxBytes + '.');
        }
        this.monitor = new TaskQueue.QueueMonitor(){

            public boolean shouldNotify() {
                return maxBytes - taskQueue.spaceInBytes() >= length;
            }

            public void onNotify() throws IOException {
                OutputBuffer.this.handler = null;
                OutputBuffer.this.monitor = null;
                try {
                    handler.onWritePossible();
                }
                catch (Throwable t) {
                    handler.onError(t);
                    throw Exceptions.makeIOException((Throwable)t);
                }
            }
        };
        try {
            taskQueue.addQueueMonitor(this.monitor);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    private void handleAsyncErrors() throws IOException {
        Throwable t = this.asyncError.get();
        if (t != null) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IOException(t);
        }
    }

    private boolean writeContentChunk(boolean areHeadersCommitted, boolean isLast) throws IOException {
        CompositeBuffer bufferToFlush;
        boolean isFlushComposite;
        this.handleAsyncErrors();
        boolean bl = isFlushComposite = this.compositeBuffer != null && this.compositeBuffer.hasRemaining();
        if (isFlushComposite) {
            this.finishCurrentBuffer();
            bufferToFlush = this.compositeBuffer;
        } else if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            bufferToFlush = this.currentBuffer;
            this.currentBuffer = null;
        } else {
            bufferToFlush = null;
        }
        if (bufferToFlush != null) {
            if (isLast && !areHeadersCommitted && this.response.getContentLength() == -1L && !this.response.isChunked()) {
                this.response.setContentLength(bufferToFlush.remaining());
            }
            HttpContent.Builder builder = this.response.httpContentBuilder();
            builder.content((Buffer)bufferToFlush).last(isLast);
            this.ctx.write((Object)builder.build(), this.asyncCompletionHandler);
            if (isFlushComposite) {
                this.compositeBuffer = !isLast ? this.createCompositeBuffer() : null;
            }
            return true;
        }
        return false;
    }

    private void checkCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.memoryManager.allocate(8192);
            this.currentBuffer.allowBufferDispose(true);
        }
    }

    private void finishCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            this.compositeBuffer.append((Object)this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    private CharsetEncoder getEncoder() {
        if (this.encoder == null) {
            String encoding = this.response.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            Charset cs = Charsets.lookupCharset((String)encoding);
            this.encoder = cs.newEncoder();
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.encoder;
    }

    private boolean doCommit() {
        if (!this.committed) {
            this.committed = true;
            return true;
        }
        return false;
    }

    private void forceCommitHeaders(boolean isLast) throws IOException {
        if (isLast) {
            if (this.response != null) {
                HttpContent.Builder builder = this.response.httpContentBuilder();
                builder.last(true);
                this.ctx.write((Object)builder.build());
            }
        } else {
            this.ctx.write((Object)this.response);
        }
    }

    private CompositeBuffer createCompositeBuffer() {
        CompositeBuffer buffer = CompositeBuffer.newBuffer((MemoryManager)this.memoryManager);
        buffer.allowBufferDispose(true);
        buffer.allowInternalBuffersDispose(true);
        return buffer;
    }

    private void flushCharsToBuf(CharBuffer charBuf) throws IOException {
        this.handleAsyncErrors();
        CharsetEncoder enc = this.getEncoder();
        this.checkCurrentBuffer();
        ByteBuffer currentByteBuffer = this.currentBuffer.toByteBuffer();
        int bufferPos = this.currentBuffer.position();
        int byteBufferPos = currentByteBuffer.position();
        CoderResult res = enc.encode(charBuf, currentByteBuffer, true);
        this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
        while (res == CoderResult.OVERFLOW) {
            boolean isJustCommitted = this.doCommit();
            this.writeContentChunk(!isJustCommitted, false);
            this.checkCurrentBuffer();
            currentByteBuffer = this.currentBuffer.toByteBuffer();
            bufferPos = this.currentBuffer.position();
            byteBufferPos = currentByteBuffer.position();
            res = enc.encode(charBuf, currentByteBuffer, true);
            this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
        }
        if (res != CoderResult.UNDERFLOW) {
            throw new IOException("Encoding error");
        }
    }
}

