/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.Utils;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.grizzly.websockets.WebSocketMappingData;
import org.glassfish.grizzly.websockets.glassfish.GlassfishSupport;

public class DefaultWebSocket
extends SimpleWebSocket {
    private static final Logger LOGGER = Grizzly.logger(DefaultWebSocket.class);
    protected final HttpServletRequest servletRequest;

    public DefaultWebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(protocolHandler, listeners);
        FilterChainContext ctx = protocolHandler.getFilterChainContext();
        if (ctx != null) {
            WSRequestImpl grizzlyRequest = new WSRequestImpl();
            Response grizzlyResponse = grizzlyRequest.getResponse();
            grizzlyRequest.initialize(request, ctx, null);
            grizzlyResponse.initialize(grizzlyRequest, request.getResponse(), ctx, null, null);
            try {
                grizzlyRequest.parseSessionId();
                WSServletRequestImpl grizzlyServletRequest = new WSServletRequestImpl();
                WSServletResponseImpl grizzlyServletResponse = new WSServletResponseImpl();
                WebSocketMappingData mappingData = protocolHandler.getMappingData();
                grizzlyServletRequest.initialize((Request)grizzlyRequest, (HttpServletResponseImpl)grizzlyServletResponse, mappingData);
                grizzlyServletResponse.initialize(grizzlyResponse, grizzlyServletRequest);
                this.servletRequest = grizzlyServletRequest;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected exception", e);
            }
        } else {
            this.servletRequest = null;
        }
    }

    public HttpServletRequest getUpgradeRequest() {
        return this.servletRequest;
    }

    private static class WSServletResponseImpl
    extends HttpServletResponseImpl {
        private PrintWriter writer;

        private WSServletResponseImpl() {
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            if (this.usingOutputStream) {
                throw new IllegalStateException("Illegal attempt to call getWriter() after getOutputStream has already been called.");
            }
            this.usingWriter = true;
            if (this.writer == null) {
                this.writer = new PrintWriter(Utils.NULL_WRITER);
            }
            return this.writer;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            if (this.usingWriter) {
                throw new IllegalStateException("Illegal attempt to call getOutputStream() after getWriter() has already been called.");
            }
            this.usingOutputStream = true;
            return Utils.NULL_SERVLET_OUTPUT_STREAM;
        }
    }

    private static class WSServletRequestImpl
    extends HttpServletRequestImpl {
        private GlassfishSupport glassfishSupport;
        private String pathInfo;
        private String servletPath;
        private String contextPath;
        private boolean isUserPrincipalUpdated;
        private BufferedReader reader;

        private WSServletRequestImpl() {
        }

        public void initialize(Request request, HttpServletResponseImpl servletResponse, WebSocketMappingData mappingData) throws IOException {
            if (mappingData != null) {
                this.updatePaths(mappingData);
            } else {
                this.contextPath = request.getContextPath();
            }
            this.glassfishSupport = mappingData != null && mappingData.isGlassfish ? new GlassfishSupport(mappingData.context, mappingData.wrapper, this) : new GlassfishSupport();
            super.initialize(request, servletResponse, new WebappContext("web-socket-ctx", this.contextPath));
        }

        @Override
        public ServletInputStream getInputStream() throws IOException {
            if (this.usingReader) {
                throw new IllegalStateException("Illegal attempt to call getInputStream() after getReader() has already been called.");
            }
            this.usingInputStream = true;
            return Utils.NULL_SERVLET_INPUT_STREAM;
        }

        @Override
        public BufferedReader getReader() throws IOException {
            if (this.usingInputStream) {
                throw new IllegalStateException("Illegal attempt to call getReader() after getInputStream() has already been called.");
            }
            this.usingReader = true;
            if (this.reader == null) {
                this.reader = new BufferedReader(Utils.NULL_READER);
            }
            return this.reader;
        }

        @Override
        protected void initSession() {
            if (!this.glassfishSupport.isValid()) {
                super.initSession();
            }
        }

        @Override
        public HttpSession getSession(boolean create) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.getSession(create);
            }
            return super.getSession(create);
        }

        @Override
        public boolean isUserInRole(String role) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.isUserInRole(role);
            }
            return super.isUserInRole(role);
        }

        @Override
        public Principal getUserPrincipal() {
            this.checkGlassfishAuth();
            return super.getUserPrincipal();
        }

        @Override
        public String getRemoteUser() {
            this.checkGlassfishAuth();
            return super.getRemoteUser();
        }

        @Override
        public String getAuthType() {
            this.checkGlassfishAuth();
            return super.getAuthType();
        }

        @Override
        public String getContextPath() {
            return this.contextPath;
        }

        @Override
        public String getServletPath() {
            return this.servletPath;
        }

        @Override
        public String getPathInfo() {
            return this.pathInfo;
        }

        private void updatePaths(WebSocketMappingData mappingData) {
            this.pathInfo = mappingData.pathInfo.toString();
            this.servletPath = mappingData.wrapperPath.toString();
            this.contextPath = mappingData.contextPath.toString();
        }

        private void checkGlassfishAuth() {
            if (this.glassfishSupport.isValid() && !this.isUserPrincipalUpdated) {
                this.isUserPrincipalUpdated = true;
                this.glassfishSupport.updateUserPrincipal(this.request);
            }
        }
    }

    private static class WSResponseImpl
    extends Response {
    }

    private class WSRequestImpl
    extends Request {
        public WSRequestImpl() {
            super(new WSResponseImpl());
        }

        @Override
        protected void parseSessionId() {
            super.parseSessionId();
            Cookie[] parsedCookies = this.getCookies();
            if (parsedCookies != null) {
                for (Cookie c : parsedCookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    this.setRequestedSessionId(c.getValue());
                    this.setRequestedSessionCookie(true);
                    break;
                }
            }
        }
    }
}

