/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.spdy.SpdyHandlerFilter;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.v3.SpdySession3;
import org.glassfish.grizzly.spdy.v31.SpdySession31;

public enum SpdyVersion {
    SPDY_3(new SessionFactory(){

        @Override
        public SpdySession create(Connection<?> connection, boolean isServer, SpdyHandlerFilter handlerFilter) {
            return new SpdySession3(connection, isServer, handlerFilter);
        }
    }, "spdy/3"),
    SPDY_3_1(new SessionFactory(){

        @Override
        public SpdySession create(Connection<?> connection, boolean isServer, SpdyHandlerFilter handlerFilter) {
            return new SpdySession31(connection, isServer, handlerFilter);
        }
    }, "spdy/3.1");

    private final String toString;
    private final SessionFactory factory;

    private SpdyVersion(SessionFactory factory, String toString) {
        this.factory = factory;
        this.toString = toString;
    }

    public SpdySession newSession(Connection<?> connection, boolean isServer, SpdyHandlerFilter handlerFilter) {
        return this.factory.create(connection, isServer, handlerFilter);
    }

    public String toString() {
        return this.toString;
    }

    public static SpdyVersion fromString(String spdyVersion) {
        if (SPDY_3.toString().equalsIgnoreCase(spdyVersion)) {
            return SPDY_3;
        }
        if (SPDY_3_1.toString().equalsIgnoreCase(spdyVersion)) {
            return SPDY_3_1;
        }
        return null;
    }

    private static interface SessionFactory {
        public SpdySession create(Connection<?> var1, boolean var2, SpdyHandlerFilter var3);
    }
}

