/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.util.ArrayList;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.spdy.frames.DataFrame;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;

public abstract class SessionOutputSink {
    protected final SpdySession session;

    public SessionOutputSink(SpdySession session) {
        this.session = session;
    }

    public void close() {
    }

    protected void writeDownStream(SpdyFrame frame) {
        this.writeDownStream(frame, null);
    }

    protected void writeDownStream(SpdyFrame frame, CompletionHandler<WriteResult> completionHandler) {
        this.session.getDownstreamChain().write(this.session.getConnection(), null, (Object)frame, completionHandler, (MessageCloner)null);
    }

    protected <K> void writeDownStream(K anyMessage, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) {
        this.session.getDownstreamChain().write(this.session.getConnection(), null, anyMessage, completionHandler, messageCloner);
    }

    protected void writeDataDownStream(SpdyStream spdyStream, SpdyFrame headerFrame, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        Object msg;
        if (data == null) {
            this.writeDownStream(headerFrame, completionHandler, messageCloner);
            return;
        }
        DataFrame dataFrame = DataFrame.builder().streamId(spdyStream.getStreamId()).data(data).last(isLast).build();
        if (headerFrame != null) {
            ArrayList<SpdyFrame> tmpList = new ArrayList<SpdyFrame>(2);
            tmpList.add(headerFrame);
            tmpList.add(dataFrame);
            msg = tmpList;
        } else {
            msg = dataFrame;
        }
        this.writeDownStream(msg, completionHandler, messageCloner);
    }

    protected abstract void onPeerWindowUpdate(int var1) throws SpdyStreamException;

    protected abstract boolean canWrite();

    protected abstract void notifyCanWrite(WriteHandler var1);

    protected abstract int getAvailablePeerConnectionWindowSize();
}

