/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.transform;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.dice_research.opal.licenses.utils.Io;

public class EdpLcmSimpleDerivative {
    public static final String HOBBIT_OPAL = "https://hobbitdata.informatik.uni-leipzig.de/OPAL/";
    public static final String URL_DERIVATIVE = "https://hobbitdata.informatik.uni-leipzig.de/OPAL/Misc/EDP-Licence-Compatibility-Matrix/Simple-Derivative.csv";
    public static final String DIR_RESOURCES = "src/main/resources/";
    public static final String OUTPUT_FILE = "src/main/resources/edp-licence-compatibility-matrix-simple-derivative.csv";
    public List<String> ids = new LinkedList<String>();
    public Map<String, List<String>> rows = new HashMap<String, List<String>>();

    public static void main(String[] args) throws MalformedURLException, IOException {
        EdpLcmSimpleDerivative instance = new EdpLcmSimpleDerivative();
        File file = File.createTempFile(EdpLcmSimpleDerivative.class.getSimpleName(), ".csv");
        file.deleteOnExit();
        Io.download(new URL(URL_DERIVATIVE), file);
        instance.parseCsv(file);
        if (Boolean.FALSE.booleanValue()) {
            for (String string : instance.ids) {
                System.out.println(string);
            }
            for (Map.Entry entry : instance.rows.entrySet()) {
                System.out.print((String)entry.getKey());
                System.out.print(" ");
                System.out.println(entry.getValue());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        instance.createCsv(stringBuilder);
        File file2 = new File(OUTPUT_FILE);
        FileUtils.write((File)file2, (CharSequence)stringBuilder, (Charset)StandardCharsets.UTF_8);
        System.out.println("Wrote: " + file2.getAbsolutePath());
    }

    protected void parseCsv(File file) throws IOException {
        CSVParser records = CSVFormat.DEFAULT.parse((Reader)new FileReader(file));
        boolean idsParsed = false;
        for (CSVRecord csvRecord : records) {
            String id;
            if (!idsParsed && csvRecord.get(0).equals("Original Licence")) {
                Iterator iterator = csvRecord.iterator();
                iterator.next();
                while (iterator.hasNext()) {
                    id = ((String)iterator.next()).replaceAll("[ ]+", " ");
                    if (id.equals("CC-PDM 4.0")) {
                        id = "CC-PDM 1.0";
                    }
                    this.ids.add(id);
                }
                idsParsed = true;
                continue;
            }
            if (!csvRecord.get(1).equals("Yes") && !csvRecord.get(1).equals("No")) continue;
            LinkedList<String> list = new LinkedList<String>();
            id = csvRecord.get(0).replaceAll("[ ]+", " ");
            if (!this.ids.contains(id)) {
                throw new IOException("Unknown: " + id);
            }
            for (int i = 1; i < csvRecord.size(); ++i) {
                list.add(csvRecord.get(i));
            }
            this.rows.put(id, list);
        }
    }

    protected void createCsv(Appendable appendable) throws IOException {
        CSVPrinter csvPrinter = CSVFormat.DEFAULT.print(appendable);
        LinkedList<String> row = new LinkedList<String>();
        row.addAll(this.ids);
        row.add("");
        csvPrinter.printRecord(row);
        for (int i = 0; i < this.rows.entrySet().size(); ++i) {
            row = new LinkedList();
            String id = this.ids.get(i);
            for (String cell : this.rows.get(id)) {
                if (cell.equals("Yes")) {
                    row.add("1");
                    continue;
                }
                if (cell.equals("No")) {
                    row.add("0");
                    continue;
                }
                row.add(cell);
            }
            row.add(id);
            csvPrinter.printRecord(row);
        }
        csvPrinter.flush();
        csvPrinter.close();
    }
}

