/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.cc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.BackMapping;
import org.dice_research.opal.licenses.Execution;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.cc.CcData;
import org.dice_research.opal.licenses.utils.ArrayUtil;
import org.dice_research.opal.licenses.utils.Cfg;

public class CcExperimentTuples {
    private static final Logger LOGGER = LogManager.getLogger();
    private KnowledgeBase knowledgeBase;

    public static void main(String[] args) throws Exception {
        CcExperimentTuples experiment = new CcExperimentTuples();
        experiment.loadData(Cfg.getCcLicenseRdf());
        experiment.execute();
        experiment.printSpecialCases();
    }

    public void printSpecialCases() {
        String licenseUri = "http://creativecommons.org/licenses/by/3.0/";
        License license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/licenses/sampling/1.0/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        System.out.println();
        licenseUri = "http://creativecommons.org/publicdomain/zero/1.0/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/licenses/publicdomain/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/publicdomain/mark/1.0/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        System.out.println();
        licenseUri = "http://creativecommons.org/licenses/sampling+/1.0/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/licenses/sampling+/1.0/de/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/licenses/sampling+/1.0/tw/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        licenseUri = "http://creativecommons.org/licenses/sampling+/1.0/br/";
        license = this.knowledgeBase.getLicense(licenseUri);
        System.out.println(ArrayUtil.intString(license.getAttributes().getValuesArray()) + " " + license);
        System.out.println(Arrays.toString(this.knowledgeBase.getSortedAttributes().getShortFormArray()));
        System.out.println(this.knowledgeBase.toLines());
    }

    public CcExperimentTuples loadData(String dataDirectory) throws IOException {
        if (!new File(dataDirectory).exists()) {
            LOGGER.error("Directory not found: " + new File(dataDirectory).getAbsolutePath());
        }
        CcData data = new CcData().setSourceDirectory(dataDirectory).readDirectory();
        List<File> files = data.getAllRdfFiles();
        this.knowledgeBase = data.createKnowledgeBase(files);
        LOGGER.info("Created knowledge base, number of licenses: " + this.knowledgeBase.getLicenses().size());
        return this;
    }

    public CcExperimentTuples execute() throws IOException {
        int progressCounter = 0;
        LinkedList<ResultContainer> results = new LinkedList<ResultContainer>();
        for (License licenseA : this.knowledgeBase.getLicenses()) {
            for (License licenseB : this.knowledgeBase.getLicenses()) {
                if (licenseA.getUri().compareTo(licenseB.getUri()) > 0) continue;
                ArrayList<License> inputLicenses = new ArrayList<License>(2);
                inputLicenses.add(licenseA);
                inputLicenses.add(licenseB);
                Execution execution = new Execution().setKnowledgeBase(this.knowledgeBase);
                Attributes resultAttributes = execution.applyOperator(inputLicenses);
                Set<License> resultingLicenses = new BackMapping().getCompatibleLicenses(inputLicenses, resultAttributes, this.knowledgeBase);
                results.add(new ResultContainer(licenseA, licenseB, resultingLicenses));
            }
            if (++progressCounter % 25 != 0) continue;
            LOGGER.info(progressCounter + " / " + this.knowledgeBase.getLicenses().size());
        }
        TreeMap resultStats = new TreeMap();
        for (ResultContainer resultContainer : results) {
            int size = resultContainer.resultingLicenses.size();
            if (!resultStats.containsKey(size)) {
                resultStats.put(size, new LinkedList());
            }
            ((List)resultStats.get(size)).add(resultContainer);
        }
        System.out.println("Results:" + results.size());
        for (Map.Entry entry : resultStats.entrySet()) {
            System.out.println(entry.getKey() + "\t" + ((List)entry.getValue()).size());
        }
        for (Map.Entry entry : resultStats.entrySet()) {
            if (((List)entry.getValue()).size() >= 50) continue;
            for (ResultContainer resultContainer : (List)entry.getValue()) {
                System.out.println(resultContainer);
            }
        }
        for (Map.Entry entry : resultStats.entrySet()) {
            if ((Integer)entry.getKey() <= 600) continue;
            for (ResultContainer resultContainer : (List)entry.getValue()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(entry.getKey());
                stringBuilder.append("*");
                stringBuilder.append("\t");
                stringBuilder.append(resultContainer.licenseA.getUri());
                stringBuilder.append("\t");
                stringBuilder.append(resultContainer.licenseB.getUri());
                stringBuilder.append("\t");
                List<License> nonCompatible = this.knowledgeBase.getLicenses();
                nonCompatible.removeAll(resultContainer.resultingLicenses);
                stringBuilder.append(nonCompatible.toString());
                System.out.println(stringBuilder.toString());
            }
        }
        return this;
    }

    public class ResultContainer {
        public License licenseA;
        public License licenseB;
        public Set<License> resultingLicenses;

        public ResultContainer(License licenseA, License licenseB, Set<License> resultingLicenses) {
            this.licenseA = licenseA;
            this.licenseB = licenseB;
            this.resultingLicenses = resultingLicenses;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.resultingLicenses.size());
            stringBuilder.append("\t");
            stringBuilder.append(this.licenseA.getUri());
            stringBuilder.append("\t");
            stringBuilder.append(this.licenseB.getUri());
            stringBuilder.append("\t");
            stringBuilder.append(this.resultingLicenses);
            return stringBuilder.toString();
        }
    }
}

