/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.cc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.Permission;
import org.dice_research.opal.licenses.Prohibition;
import org.dice_research.opal.licenses.Requirement;
import org.dice_research.opal.licenses.utils.Cfg;
import org.dice_research.opal.licenses.utils.LineStorage;

public class CcData {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CC_NS = "http://creativecommons.org/ns#";
    public static final Resource LICENSE = ResourceFactory.createResource((String)"http://creativecommons.org/ns#License");
    public static final Property PROP_PROHIBITS = ResourceFactory.createProperty((String)"http://creativecommons.org/ns#prohibits");
    public static final Property PROP_REQUIRES = ResourceFactory.createProperty((String)"http://creativecommons.org/ns#requires");
    public static final Property PROP_PERMITS = ResourceFactory.createProperty((String)"http://creativecommons.org/ns#permits");
    public static final Property PROP_REPLACED_BY = DCTerms.isReplacedBy;
    public static final Property PROP_TITLE = DCTerms.title;
    public static final Property PROP_ID = DC.identifier;
    public static final String DERIVATIVE_WORKS = "http://creativecommons.org/ns#DerivativeWorks";
    public static final String SHARE_ALIKE = "http://creativecommons.org/ns#ShareAlike";
    private String sourceDirectory;
    private static List<File> allRdfFiles;

    public static void main(String[] args) throws Exception {
        CcData cc = new CcData().setSourceDirectory(Cfg.getCcLicenseRdf()).readDirectory();
        List<File> rdfFiles = cc.getMatixFiles();
        for (File file : rdfFiles) {
            System.out.println(file);
        }
        System.out.println();
        KnowledgeBase knowledgeBase = cc.createKnowledgeBase(rdfFiles);
        System.out.println(knowledgeBase.getSortedAttributes().toLines());
        for (License license : knowledgeBase.getLicenses()) {
            System.out.println(license);
            System.out.println(Arrays.toString(license.getAttributes().getValuesArray()));
        }
    }

    public KnowledgeBase createKnowledgeBase(List<File> files) {
        for (File file : files) {
            if (file.exists()) continue;
            throw new RuntimeException("File not found: " + file);
        }
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        TreeSet<String> permissions = new TreeSet<String>();
        TreeSet<String> prohibitions = new TreeSet<String>();
        TreeSet<String> requirements = new TreeSet<String>();
        for (File file : files) {
            this.extractAttributes(file, permissions, prohibitions, requirements);
        }
        for (String attribute : permissions) {
            Attribute permission = new Permission().setUri(attribute);
            if (permission.getUri().equals(DERIVATIVE_WORKS)) {
                permission.setTypePermissionOfDerivates(true);
            }
            knowledgeBase.addAttribute(permission);
        }
        for (String attribute : prohibitions) {
            knowledgeBase.addAttribute(new Prohibition().setUri(attribute));
        }
        for (String attribute : requirements) {
            Attribute requirement = new Requirement().setUri(attribute);
            if (requirement.getUri().equals(SHARE_ALIKE)) {
                requirement.setTypeAttribueEquality(true);
            }
            knowledgeBase.addAttribute(requirement);
        }
        for (File file : files) {
            this.addLicense(file, knowledgeBase);
        }
        return knowledgeBase;
    }

    private void addLicense(File file, KnowledgeBase knowledgeBase) {
        Model model = RDFDataMgr.loadModel((String)file.toURI().toString(), (Lang)Lang.RDFXML);
        ResIterator licensesIt = model.listResourcesWithProperty(RDF.type, (RDFNode)LICENSE);
        while (licensesIt.hasNext()) {
            License license = new License();
            Resource licenseResource = (Resource)licensesIt.next();
            license.setUri(licenseResource.getURI());
            StmtIterator stmtIterator = licenseResource.listProperties(PROP_ID);
            if (stmtIterator.hasNext()) {
                license.setName(((Statement)stmtIterator.next()).getObject().toString());
            }
            if (stmtIterator.hasNext()) {
                throw new RuntimeException("Multiple IDs " + license.getName() + " " + stmtIterator.next() + " " + file.getAbsolutePath());
            }
            TreeSet<String> permissions = new TreeSet<String>();
            TreeSet<String> prohibitions = new TreeSet<String>();
            TreeSet<String> requirements = new TreeSet<String>();
            stmtIterator = licenseResource.listProperties(PROP_PERMITS);
            while (stmtIterator.hasNext()) {
                permissions.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
            stmtIterator = licenseResource.listProperties(PROP_PROHIBITS);
            while (stmtIterator.hasNext()) {
                prohibitions.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
            stmtIterator = licenseResource.listProperties(PROP_REQUIRES);
            while (stmtIterator.hasNext()) {
                requirements.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
            for (Attribute attribute : knowledgeBase.getSortedAttributes().getList()) {
                if (attribute instanceof Permission) {
                    Attribute permission = new Permission().setUri(attribute.getUri()).setValue(permissions.contains(attribute.getUri()));
                    if (attribute.getUri().equals(DERIVATIVE_WORKS)) {
                        permission.setTypePermissionOfDerivates(true);
                    }
                    license.getAttributes().addAttribute(permission);
                    continue;
                }
                if (attribute instanceof Prohibition) {
                    license.getAttributes().addAttribute(new Prohibition().setUri(attribute.getUri()).setValue(prohibitions.contains(attribute.getUri())));
                    continue;
                }
                if (attribute instanceof Requirement) {
                    Attribute requirement = new Requirement().setUri(attribute.getUri()).setValue(requirements.contains(attribute.getUri()));
                    if (attribute.getUri().equals(SHARE_ALIKE)) {
                        requirement.setTypeAttribueEquality(true);
                    }
                    license.getAttributes().addAttribute(requirement);
                    continue;
                }
                throw new RuntimeException("Unknown type of attribute");
            }
            if (knowledgeBase.getLicenseUris().contains(license.getUri())) {
                LOGGER.warn("URI already contained: " + license.getUri() + " " + file.getAbsolutePath());
            }
            knowledgeBase.addLicense(license);
        }
    }

    private void extractAttributes(File file, Set<String> permissions, Set<String> prohibitions, Set<String> requirements) {
        Model model = RDFDataMgr.loadModel((String)file.toURI().toString(), (Lang)Lang.RDFXML);
        ResIterator licensesIt = model.listResourcesWithProperty(RDF.type, (RDFNode)LICENSE);
        while (licensesIt.hasNext()) {
            Resource licenseResource = (Resource)licensesIt.next();
            StmtIterator stmtIterator = licenseResource.listProperties(PROP_PERMITS);
            while (stmtIterator.hasNext()) {
                permissions.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
            stmtIterator = licenseResource.listProperties(PROP_PROHIBITS);
            while (stmtIterator.hasNext()) {
                prohibitions.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
            stmtIterator = licenseResource.listProperties(PROP_REQUIRES);
            while (stmtIterator.hasNext()) {
                requirements.add(((Statement)stmtIterator.next()).getObject().asResource().getURI());
            }
        }
    }

    public List<File> getMatixFiles() {
        LinkedList<File> files = new LinkedList<File>();
        files.add(new File(this.sourceDirectory, "creativecommons.org_publicdomain_mark_1.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_publicdomain_zero_1.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by_4.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by-sa_4.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by-nc_4.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by-nd_4.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by-nc-sa_4.0_.rdf"));
        files.add(new File(this.sourceDirectory, "creativecommons.org_licenses_by-nc-nd_4.0_.rdf"));
        return files;
    }

    public List<File> getNonReplacedFiles() {
        String storageId = "cc-non-replaced";
        if (LineStorage.exists(storageId)) {
            return LineStorage.read(storageId).stream().collect(Collectors.mapping(l -> new File((String)l), Collectors.toList()));
        }
        LinkedList<File> files = new LinkedList<File>();
        for (File file : this.getAllRdfFiles()) {
            Model model = RDFDataMgr.loadModel((String)file.toURI().toString(), (Lang)Lang.RDFXML);
            ResIterator licensesIt = model.listResourcesWithProperty(RDF.type, (RDFNode)LICENSE);
            while (licensesIt.hasNext()) {
                Resource licenseResource = (Resource)licensesIt.next();
                StmtIterator idIt = licenseResource.listProperties(PROP_REPLACED_BY);
                if (idIt.hasNext()) continue;
                files.add(file);
            }
        }
        LineStorage.write(storageId, files.stream().map(f -> Paths.get(f.getAbsolutePath(), new String[0]).toString()).collect(Collectors.toList()));
        return files;
    }

    public List<File> getAllRdfFiles() {
        if (allRdfFiles == null) {
            return new ArrayList<File>(0);
        }
        return allRdfFiles;
    }

    public CcData readDirectory() throws IOException {
        if (this.sourceDirectory == null) {
            throw new NullPointerException("Source directory not set.");
        }
        File directory = new File(this.sourceDirectory);
        if (!directory.canRead()) {
            throw new IOException("Can not read " + directory);
        }
        allRdfFiles = Files.list(Paths.get(directory.toURI())).map(p -> p.toFile()).filter(f -> f.getName().endsWith("rdf")).filter(f -> !f.getName().equals("creativecommons.org_licenses_by-nc-sa_3.0_za_.rdf")).filter(f -> !f.getName().equals("creativecommons.org_licenses_by-nc_3.0_za_.rdf")).collect(Collectors.toList());
        return this;
    }

    public CcData setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        return this;
    }
}

