/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.jena.riot.Lang;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.utils.CcRel;
import org.dice_research.opal.licenses.utils.CollectionUtil;

public class KnowledgeBases {
    public static final String ID_CC = "CreativeCommons";
    public static final String ID_CC_MATRIX = "CreativeCommons-LicenseCompatibilityChart";
    public static final String ID_EDP_LCM = "EuropeanDataPortal-LicenseCompatibilityMatrix";
    public static final File KB_DIRECTORY = new File("src/main/resources/knowledge-bases");
    public static final String KB_FILE_SUFFIX = ".ttl";
    public static final String KB_SUB_DIRECTORY = "knowledge-bases";

    public KnowledgeBase importCreativeCommons() {
        return this.importKnowledgeBase(ID_CC, "http://creativecommons.org/ns#ShareAlike", "http://creativecommons.org/ns#DerivativeWorks");
    }

    public KnowledgeBase importCreativeCommonsMatrix() {
        return this.importKnowledgeBase(ID_CC_MATRIX, "http://creativecommons.org/ns#ShareAlike", "http://creativecommons.org/ns#DerivativeWorks");
    }

    public KnowledgeBase importEDP_Matrix() {
        return this.importKnowledgeBase(ID_EDP_LCM, "http://example.org/Share-Alike", "http://example.org/Derivative-Works");
    }

    private KnowledgeBase importKnowledgeBase(String knowledgeBaseId, String attribueEqualityUri, String permissionOfDerivatesUri) {
        URI uri;
        try {
            uri = this.getClass().getClassLoader().getResource("knowledge-bases/" + knowledgeBaseId + KB_FILE_SUFFIX).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new CcRel(CollectionUtil.stringToSet(attribueEqualityUri), CollectionUtil.stringToSet(permissionOfDerivatesUri)).importResource(uri, Lang.TURTLE);
    }
}

