/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.Permission;
import org.dice_research.opal.licenses.Prohibition;
import org.dice_research.opal.licenses.Requirement;

public enum AttributeFactory {
    INSTANCE;


    public static AttributeFactory get() {
        return INSTANCE;
    }

    public Attribute createAttribute(String type) {
        if (type == null) {
            throw new NullPointerException("Type of attribute is null");
        }
        if (type.equals(Permission.TYPE)) {
            return new Permission();
        }
        if (type.equals(Prohibition.TYPE)) {
            return new Prohibition();
        }
        if (type.equals(Requirement.TYPE)) {
            return new Requirement();
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public Attribute createAttribute(String type, String uri) {
        if (uri == null) {
            throw new NullPointerException("URI of attribute is null");
        }
        return this.createAttribute(type).setUri(uri);
    }

    public Attribute createAttribute(String type, String uri, Boolean value) {
        if (value == null) {
            throw new NullPointerException("Value of attribute is null");
        }
        return this.createAttribute(type, uri).setValue(value);
    }

    public Attribute createAttribute(Attribute attribute, boolean includeValue) {
        if (attribute == null) {
            throw new NullPointerException("Attribute is null");
        }
        Attribute newAttribute = null;
        if (includeValue) {
            if (!attribute.hasValue()) {
                throw new RuntimeException("No value given: " + attribute.toString());
            }
            newAttribute = this.createAttribute(attribute.getType(), attribute.getUri(), attribute.getValue());
        } else {
            newAttribute = this.createAttribute(attribute.getType(), attribute.getUri());
        }
        newAttribute.setTypePermissionOfDerivates(attribute.isTypePermissionOfDerivates());
        newAttribute.setTypeAttribueEquality(attribute.isTypeAttribueEquality());
        return newAttribute;
    }
}

