/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.text.ParseException;
import java.util.Objects;
import org.dice_research.opal.licenses.MetaAttribute;

public abstract class Attribute
extends MetaAttribute {
    private String uri = null;
    private Boolean value = null;

    public static final boolean binaryToBoolean(int binary) throws ParseException {
        if (binary == 0) {
            return false;
        }
        if (binary == 1) {
            return true;
        }
        throw new ParseException(Integer.toString(binary), 0);
    }

    public static final int booleanToBinary(boolean bool) {
        if (!bool) {
            return 0;
        }
        return 1;
    }

    public int compareTo(Attribute o) {
        return this.getUri().compareTo(o.getUri());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int getBinaryValue() throws NullPointerException {
        if (this.getValue() == null) {
            throw new NullPointerException();
        }
        return Attribute.booleanToBinary(this.getValue());
    }

    public Boolean getInternalValue() throws NullPointerException {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return this.invertForComputation() ? !this.value.booleanValue() : this.value;
    }

    public abstract String getShortForm();

    public abstract String getType();

    public String getUri() throws NullPointerException {
        if (this.uri == null) {
            throw new NullPointerException();
        }
        return this.uri;
    }

    public Boolean getValue() throws NullPointerException {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean hasValue() throws NullPointerException {
        return this.value != null;
    }

    public abstract boolean invertForComputation();

    public Attribute setUri(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
        return this;
    }

    public Attribute setValue(boolean value) {
        this.value = value;
        return this;
    }

    public Attribute setValue(int binary) throws ParseException {
        this.setValue(Attribute.binaryToBoolean(binary));
        return this;
    }

    public Attribute setValueByInternal(boolean internalValue) {
        this.value = this.invertForComputation() ? !internalValue : internalValue;
        return this;
    }

    public String toString() {
        return this.getUri() + (this.value == null ? "" : "=" + this.value) + " (" + (this.isMetaAttribute() ? "Meta-" : "") + this.getType() + ")";
    }
}

