/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.AttributeFactory;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.Permission;
import org.dice_research.opal.licenses.Prohibition;
import org.dice_research.opal.licenses.Requirement;

public class CcRel {
    public static final String CCREL = "http://creativecommons.org/ns#";
    public static final Resource R_LICENSE = ResourceFactory.createResource("http://creativecommons.org/ns#License");
    public static final Property P_REQUIRES = ResourceFactory.createProperty("http://creativecommons.org/ns#requires");
    public static final Property P_PERMITS = ResourceFactory.createProperty("http://creativecommons.org/ns#permits");
    public static final Property P_PROHIBITS = ResourceFactory.createProperty("http://creativecommons.org/ns#prohibits");
    public static final Property P_TITLE = DCTerms.title;
    private Collection<String> attribueEqualityUris;
    private Collection<String> permissionOfDerivatesUris;

    public CcRel(Collection<String> attribueEqualityUris, Collection<String> permissionOfDerivatesUris) {
        this.attribueEqualityUris = attribueEqualityUris;
        this.permissionOfDerivatesUris = permissionOfDerivatesUris;
    }

    public void export(KnowledgeBase kb, File file, Lang lang) {
        Model model = this.export(kb);
        if (lang.equals(Lang.TURTLE)) {
            this.exportTurtle(kb, file, null, null);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            RDFDataMgr.write((OutputStream)fos, model, lang);
            fos.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void exportTurtle(KnowledgeBase kb, File file, Map<String, String> prefixes, List<String> commentLines) {
        Model model = this.export(kb);
        model.setNsPrefix("cc", CCREL);
        model.setNsPrefix("dct", "http://purl.org/dc/terms/");
        if (prefixes != null) {
            for (Map.Entry<String, String> prefix : prefixes.entrySet()) {
                model.setNsPrefix(prefix.getKey(), prefix.getValue());
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            if (commentLines != null) {
                for (String line : commentLines) {
                    fos.write("# ".getBytes());
                    fos.write(line.getBytes());
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            RDFDataMgr.write((OutputStream)fos, model, Lang.TURTLE);
            fos.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public Model export(KnowledgeBase kb) {
        Model model = ModelFactory.createDefaultModel();
        for (License license : kb.getLicenses()) {
            Resource rLicense = ResourceFactory.createResource(license.getUri());
            model.add(rLicense, RDF.type, R_LICENSE);
            if (license.getName() != null && !license.getName().isEmpty()) {
                model.add(rLicense, P_TITLE, ResourceFactory.createPlainLiteral(license.getName()));
            }
            for (Attribute attribute : license.getAttributes().getUriToAttributeMap().values()) {
                if (!attribute.getValue().booleanValue()) continue;
                Resource rAttribute = ResourceFactory.createResource(attribute.getUri());
                if (attribute instanceof Permission) {
                    model.add(rLicense, P_PERMITS, rAttribute);
                    continue;
                }
                if (attribute instanceof Prohibition) {
                    model.add(rLicense, P_PROHIBITS, rAttribute);
                    continue;
                }
                if (attribute instanceof Requirement) {
                    model.add(rLicense, P_REQUIRES, rAttribute);
                    continue;
                }
                throw new RuntimeException("Unknown attibute type");
            }
        }
        return model;
    }

    public KnowledgeBase importFile(File file, Lang lang) {
        return this.importModel(RDFDataMgr.loadModel(file.toURI().toString(), lang));
    }

    public KnowledgeBase importResource(URI uri, Lang lang) {
        return this.importModel(RDFDataMgr.loadModel(uri.toString(), lang));
    }

    public KnowledgeBase importModel(Model model) {
        Resource rPolicy;
        KnowledgeBase kb = new KnowledgeBase();
        ResIterator policyIt = model.listSubjectsWithProperty(RDF.type, R_LICENSE);
        while (policyIt.hasNext()) {
            Attribute attribute;
            Resource rRule;
            RDFNode nRule;
            rPolicy = (Resource)policyIt.next();
            StmtIterator ruleIt = rPolicy.listProperties(P_PERMITS);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Permission.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
            ruleIt = rPolicy.listProperties(P_PROHIBITS);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Prohibition.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
            ruleIt = rPolicy.listProperties(P_REQUIRES);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Requirement.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
        }
        policyIt = model.listSubjectsWithProperty(RDF.type, R_LICENSE);
        while (policyIt.hasNext()) {
            rPolicy = (Resource)policyIt.next();
            License license = new License();
            license.setUri(rPolicy.getURI());
            Statement stmt = rPolicy.getProperty(P_TITLE);
            if (stmt != null) {
                license.setName(stmt.getObject().asLiteral().getString());
            }
            Attributes attributes = new Attributes();
            for (Attribute attribute : kb.getSortedAttributes().getList()) {
                attributes.addAttribute(AttributeFactory.get().createAttribute(attribute, false).setValue(false));
            }
            license.setAttributes(attributes);
            this.updateAttributes(rPolicy, P_PERMITS, attributes);
            this.updateAttributes(rPolicy, P_PROHIBITS, attributes);
            this.updateAttributes(rPolicy, P_REQUIRES, attributes);
            kb.addLicense(license);
        }
        for (License license : kb.getLicenses()) {
            for (Attribute attribute : kb.getSortedAttributes().getList()) {
                if (license.getAttributes().getUris().contains(attribute.getUri())) continue;
                license.getAttributes().addAttribute(AttributeFactory.get().createAttribute(attribute, false).setValue(false));
            }
        }
        return kb;
    }

    private void updateAttributes(Resource rPolicy, Property pRule, Attributes attributes) {
        StmtIterator ruleIt = rPolicy.listProperties(pRule);
        while (ruleIt.hasNext()) {
            RDFNode nRule = ((Statement)ruleIt.next()).getObject();
            if (!nRule.isURIResource()) continue;
            Resource rRule = nRule.asResource();
            attributes.getAttribute(rRule.getURI()).setValue(true);
        }
    }

    private void addMetaAttribute(Resource rRule, Attribute attribute) {
        if (this.attribueEqualityUris.contains(rRule.getURI())) {
            attribute.setTypeAttribueEquality(true);
        } else if (this.permissionOfDerivatesUris.contains(rRule.getURI())) {
            attribute.setTypePermissionOfDerivates(true);
        }
    }
}

