/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.transform;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.edplcm.EdpLcmKnowledgeBase;
import org.dice_research.opal.licenses.edplcm.EpdLcmDerivates;

public class EdpLcmShareAlike {
    public static final String URI_SHARE_ALIKE = "http://example.org/Share-Alike";
    public static final String DIR_RESOURCES = "src/main/resources/";
    public static final String OUTPUT_FILE = "edp-licence-compatibility-matrix-share-alike.txt";

    public static void main(String[] args) throws IOException {
        EdpLcmKnowledgeBase knowledgeBase = new EdpLcmKnowledgeBase();
        knowledgeBase.load();
        HashMap<String, String> namesToUris = new HashMap<String, String>();
        for (License license : knowledgeBase.getLicenses()) {
            namesToUris.put(license.getName(), knowledgeBase.getUriForName(license.getName()));
        }
        LinkedList<License> shareAlikeLicenses = new LinkedList<License>();
        for (License license : knowledgeBase.getLicenses()) {
            for (Attribute attribute : license.getAttributes().getList()) {
                if (!attribute.getUri().equals(URI_SHARE_ALIKE) || !attribute.getValue().booleanValue()) continue;
                shareAlikeLicenses.add(license);
            }
        }
        HashMap<License, List<String>> hashMap = new HashMap<License, List<String>>();
        EpdLcmDerivates derivates = new EpdLcmDerivates();
        for (License license : shareAlikeLicenses) {
            String string = knowledgeBase.getUriForName(license.getName());
            hashMap.put(license, derivates.getCompatibleUris(string));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : hashMap.entrySet()) {
            stringBuilder.append(((License)entry.getKey()).getUri());
            stringBuilder.append(System.lineSeparator());
            for (String licenseUri : (List)entry.getValue()) {
                stringBuilder.append(licenseUri);
                stringBuilder.append(System.lineSeparator());
            }
            stringBuilder.append(System.lineSeparator());
        }
        File file = new File(DIR_RESOURCES, OUTPUT_FILE);
        FileUtils.write(file, (CharSequence)stringBuilder.toString(), StandardCharsets.UTF_8);
        System.out.println("Wrote: " + file.getAbsolutePath());
    }
}

