/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.transform;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.dice_research.opal.licenses.utils.Io;

public class EdpLcmLicenceDescriptions {
    public static final String HOBBIT_OPAL = "https://hobbitdata.informatik.uni-leipzig.de/OPAL/";
    public static final String URL_LICENSES = "https://hobbitdata.informatik.uni-leipzig.de/OPAL/Misc/EDP-Licence-Compatibility-Matrix/Licence-Descriptions.csv";
    public static final String DIR_RESOURCES = "src/main/resources/";
    public static final String OUTPUT_FILE = "src/main/resources/edp-licence-compatibility-matrix-licence-descriptions.csv";
    public static final String TYPE_PER = "Permission";
    public static final String TYPE_REQ = "Requirement";
    public static final String TYPE_PRO = "Prohibition";
    public List<String> types = new LinkedList<String>();
    public List<String> headers = new LinkedList<String>();
    public List<List<String>> rows = new LinkedList<List<String>>();

    public static void main(String[] args) throws MalformedURLException, IOException {
        EdpLcmLicenceDescriptions instance = new EdpLcmLicenceDescriptions();
        File file = File.createTempFile(EdpLcmLicenceDescriptions.class.getSimpleName(), ".csv");
        file.deleteOnExit();
        Io.download(new URL(URL_LICENSES), file);
        instance.parseCsv(file);
        if (Boolean.FALSE.booleanValue()) {
            for (String type : instance.types) {
                System.out.print(type);
                System.out.print(" ");
            }
            System.out.println();
            for (String header : instance.headers) {
                System.out.print(header);
                System.out.print(" ");
            }
            System.out.println();
            for (List<String> row : instance.rows) {
                Iterator<String> itCells = row.iterator();
                while (itCells.hasNext()) {
                    System.out.print(itCells.next());
                    System.out.print(" ");
                }
                System.out.println();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        instance.createCsv(stringBuilder);
        System.out.println(stringBuilder);
        File outFile = new File(OUTPUT_FILE);
        FileUtils.write(outFile, (CharSequence)stringBuilder, StandardCharsets.UTF_8);
        System.out.println("Wrote: " + outFile.getAbsolutePath());
    }

    protected void parseCsv(File file) throws IOException {
        CSVParser records = CSVFormat.DEFAULT.parse(new FileReader(file));
        boolean typesParsed = false;
        boolean headersParsed = false;
        for (CSVRecord csvRecord : records) {
            if (!typesParsed && csvRecord.get(2).equals("Permissions")) {
                Iterator<String> iterator = csvRecord.iterator();
                String currentType = null;
                while (iterator.hasNext()) {
                    String type = iterator.next();
                    if (type.isEmpty()) {
                        if (currentType == null) continue;
                        this.types.add(currentType);
                        continue;
                    }
                    if (type.equals("Permissions")) {
                        currentType = TYPE_PER;
                        this.types.add(currentType);
                        continue;
                    }
                    if (type.equals("Requirements")) {
                        currentType = TYPE_REQ;
                        this.types.add(currentType);
                        continue;
                    }
                    if (type.equals("Prohibitions")) {
                        currentType = TYPE_PRO;
                        this.types.add(currentType);
                        continue;
                    }
                    throw new RuntimeException();
                }
                typesParsed = true;
                continue;
            }
            if (!headersParsed && csvRecord.get(0).equals("Licence")) {
                for (int i = 2; i < csvRecord.size(); ++i) {
                    this.headers.add(csvRecord.get(i));
                }
                this.headers.add(csvRecord.get(1));
                this.headers.add(csvRecord.get(0));
                headersParsed = true;
                continue;
            }
            if (!csvRecord.get(2).equals("Yes") && !csvRecord.get(2).equals("No")) continue;
            LinkedList<String> list = new LinkedList<String>();
            for (int i = 2; i < csvRecord.size(); ++i) {
                list.add(csvRecord.get(i));
            }
            list.add(csvRecord.get(1));
            list.add(csvRecord.get(0).replaceAll("[ ]+", " "));
            this.rows.add(list);
        }
    }

    protected void createCsv(Appendable appendable) throws IOException {
        CSVPrinter csvPrinter = CSVFormat.DEFAULT.print(appendable);
        LinkedList<String> row = new LinkedList<String>();
        row.addAll(this.headers);
        csvPrinter.printRecord(row);
        row = new LinkedList();
        row.addAll(this.types);
        row.add("");
        row.add("");
        csvPrinter.printRecord(row);
        for (List<String> inRow : this.rows) {
            row = new LinkedList();
            for (String cell : inRow) {
                if (cell.equals("Yes")) {
                    row.add("1");
                    continue;
                }
                if (cell.equals("No")) {
                    row.add("0");
                    continue;
                }
                if (cell.equals("N.A.")) {
                    row.add("-1");
                    continue;
                }
                row.add(cell);
            }
            csvPrinter.printRecord(row);
        }
        csvPrinter.flush();
        csvPrinter.close();
    }
}

