/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.edplcm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.edplcm.EdpLcmKnowledgeBase;
import org.dice_research.opal.licenses.transform.EdpLcmUriMapping;

public class EpdLcmDerivates {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String RESOURCE_CSV = "edp-licence-compatibility-matrix-simple-derivative.csv";
    protected Vector<Vector<Boolean>> matrix = new Vector();
    protected LinkedHashMap<String, Integer> uris = new LinkedHashMap();
    protected boolean isLoaded = false;

    public List<String> getUris() throws IOException {
        if (!this.isLoaded) {
            this.load();
        }
        return new ArrayList<String>(this.uris.keySet());
    }

    public List<String> getCompatibleUris(String uri) throws IOException {
        if (!this.isLoaded) {
            this.load();
        }
        LinkedList<String> compatibleUris = new LinkedList<String>();
        Vector<Boolean> compatible = this.matrix.get(this.getIndexOfUri(uri));
        for (String uriB : this.getUris()) {
            if (!compatible.get(this.getIndexOfUri(uriB)).booleanValue()) continue;
            compatibleUris.add(uriB);
        }
        return compatibleUris;
    }

    Integer getIndexOfUri(String uri) {
        if (!this.uris.containsKey(uri)) {
            throw new RuntimeException("URI not found: " + uri);
        }
        return this.uris.get(uri);
    }

    public Boolean getValue(String uriA, String uriB) throws IOException {
        if (!this.isLoaded) {
            this.load();
        }
        return this.matrix.get(this.getIndexOfUri(uriA)).get(this.getIndexOfUri(uriB));
    }

    public EpdLcmDerivates load() throws IOException {
        boolean idsParsed = false;
        EdpLcmKnowledgeBase edpLcmKnowledgeBase = new EdpLcmKnowledgeBase().load();
        Map<String, String> namesToUris = EdpLcmUriMapping.mapNamesToUris(edpLcmKnowledgeBase);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_CSV);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        CSVParser csvRecords = CSVFormat.DEFAULT.parse(bufferedReader);
        int rowId = -1;
        for (CSVRecord csvRecord : csvRecords) {
            int i;
            ++rowId;
            if (!idsParsed) {
                for (i = 0; i < csvRecord.size() - 1; ++i) {
                    this.uris.put(namesToUris.get(csvRecord.get(i)), i);
                }
                idsParsed = true;
                continue;
            }
            Vector<Boolean> vector = new Vector<Boolean>();
            for (i = 0; i < csvRecord.size() - 1; ++i) {
                vector.add(!csvRecord.get(i).equals("0"));
            }
            String uri = namesToUris.get(csvRecord.get(csvRecord.size() - 1));
            if (!this.uris.get(uri).equals(rowId - 1)) {
                throw new RuntimeException(uri + " does not match " + (rowId - 1));
            }
            this.matrix.add(vector);
        }
        inputStream.close();
        this.isLoaded = true;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<Object> uris = new ArrayList();
        try {
            uris = this.getUris();
        }
        catch (IOException e2) {
            LOGGER.error(e2);
        }
        for (String string : uris) {
            for (String string2 : uris) {
                try {
                    stringBuilder.append(Attribute.booleanToBinary(this.getValue(string, string2)));
                }
                catch (IOException e3) {
                    LOGGER.error(e3);
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append(string == null ? "-" : string);
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

