/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.cc;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.BackMapping;
import org.dice_research.opal.licenses.Execution;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.cc.CcData;
import org.dice_research.opal.licenses.utils.Cfg;

public class CcExperimentTriples {
    public static final boolean WRITE_OUTPUT_LISTS = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, Integer> licenceIndex = new HashMap<String, Integer>();
    private KnowledgeBase knowledgeBase;

    public static void main(String[] args) throws Exception {
        CcExperimentTriples experiment = new CcExperimentTriples();
        experiment.loadData(Cfg.getCcLicenseRdf());
        experiment.execute();
        experiment.printResults(new File("").getAbsolutePath());
    }

    public CcExperimentTriples loadData(String dataDirectory) throws IOException {
        if (!new File(dataDirectory).exists()) {
            LOGGER.error("Directory not found: " + new File(dataDirectory).getAbsolutePath());
            return null;
        }
        CcData data = new CcData().setSourceDirectory(dataDirectory).readDirectory();
        List<File> files = data.getAllRdfFiles();
        this.knowledgeBase = data.createKnowledgeBase(files);
        LOGGER.info("Created knowledge base, number of licenses: " + this.knowledgeBase.getLicenses().size());
        return this;
    }

    public void printResults(String resultFilesDirectory) throws IOException {
        File directory = new File(resultFilesDirectory);
        if (!directory.exists()) {
            LOGGER.error("Directory not found: " + directory.getAbsolutePath());
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("result") && name.endsWith(".txt");
            }
        };
        File[] resultFiles = directory.listFiles(filter);
        TreeMap<Integer, Integer> resultStats = new TreeMap<Integer, Integer>();
        for (File file : resultFiles) {
            for (String line : FileUtils.readLines(file, StandardCharsets.UTF_8)) {
                Integer size = Integer.valueOf(line.substring(0, line.indexOf("\t")));
                if (!resultStats.containsKey(size)) {
                    resultStats.put(size, 0);
                }
                resultStats.put(size, (Integer)resultStats.get(size) + 1);
            }
        }
        int counter = 0;
        for (Map.Entry entry : resultStats.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
            counter += ((Integer)entry.getValue()).intValue();
        }
        System.out.println();
        System.out.println(counter);
    }

    public CcExperimentTriples execute() throws IOException {
        int progressCounter = 1;
        File indexFile = new File("index.txt");
        int counter = 1;
        for (License license : this.knowledgeBase.getLicenses()) {
            this.licenceIndex.put(license.getUri(), counter++);
        }
        for (Map.Entry entry : this.licenceIndex.entrySet()) {
            FileUtils.writeStringToFile(indexFile, (String)entry.getKey() + "\t" + entry.getValue() + "\n", StandardCharsets.UTF_8, true);
        }
        LOGGER.info("Wrote: " + indexFile.getAbsolutePath());
        for (License license : this.knowledgeBase.getLicenses()) {
            File file = new File("result" + progressCounter++ + ".txt");
            if (file.exists()) continue;
            LinkedList<ResultContainer> results = new LinkedList<ResultContainer>();
            for (License licenseB : this.knowledgeBase.getLicenses()) {
                for (License licenseC : this.knowledgeBase.getLicenses()) {
                    if (license.getUri().compareTo(licenseB.getUri()) > 0 || license.getUri().compareTo(licenseC.getUri()) > 0 || licenseB.getUri().compareTo(licenseC.getUri()) > 0) continue;
                    ArrayList<License> inputLicenses = new ArrayList<License>(3);
                    inputLicenses.add(license);
                    inputLicenses.add(licenseB);
                    inputLicenses.add(licenseC);
                    Execution execution = new Execution().setKnowledgeBase(this.knowledgeBase);
                    Attributes resultAttributes = execution.applyOperator(inputLicenses);
                    Set<License> resultingLicenses = new BackMapping().getCompatibleLicenses(inputLicenses, resultAttributes, this.knowledgeBase);
                    results.add(new ResultContainer(license, licenseB, licenseC, resultingLicenses));
                }
            }
            for (ResultContainer resultContainer : results) {
                FileUtils.write(file, (CharSequence)(resultContainer.toString() + "\n"), StandardCharsets.UTF_8, true);
            }
            LOGGER.info("Wrote: " + file.getAbsolutePath());
        }
        return this;
    }

    public class ResultContainer {
        public License licenseA;
        public License licenseB;
        public License licenseC;
        public Set<License> resultingLicenses;

        public ResultContainer(License licenseA, License licenseB, License licenseC, Set<License> resultingLicenses) {
            this.licenseA = licenseA;
            this.licenseB = licenseB;
            this.licenseC = licenseC;
            this.resultingLicenses = resultingLicenses;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.resultingLicenses.size());
            stringBuilder.append("\t");
            stringBuilder.append(CcExperimentTriples.this.licenceIndex.get(this.licenseA.getUri()));
            stringBuilder.append("\t");
            stringBuilder.append(CcExperimentTriples.this.licenceIndex.get(this.licenseB.getUri()));
            stringBuilder.append("\t");
            stringBuilder.append(CcExperimentTriples.this.licenceIndex.get(this.licenseC.getUri()));
            return stringBuilder.toString();
        }
    }
}

