/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.Permission;
import org.dice_research.opal.licenses.Prohibition;
import org.dice_research.opal.licenses.Requirement;

public class BackMapping {
    public Set<License> getCompatibleLicenses(List<License> inputLicenses, Attributes setting, KnowledgeBase knowledgeBase) {
        return new HashSet<License>(this.getCompatibleLicensesList(inputLicenses, setting, knowledgeBase));
    }

    public List<License> getCompatibleLicensesList(List<License> inputLicenses, Attributes setting, KnowledgeBase knowledgeBase) {
        if (inputLicenses.isEmpty()) {
            return new ArrayList<License>(0);
        }
        for (Attribute attribute : knowledgeBase.getSortedAttributes().getList()) {
            if (!attribute.isTypePermissionOfDerivates()) continue;
            for (License license : inputLicenses) {
                if (license.getAttributes().getAttribute(attribute.getUri()).getValue().booleanValue()) continue;
                return new ArrayList<License>(0);
            }
        }
        List<License> resultingLicenses = this.removeLessRestrictive(setting, knowledgeBase.getLicenses(), false);
        for (License shareAlikeInputLicense : inputLicenses) {
            for (License license : knowledgeBase.getLicenses()) {
                if (!shareAlikeInputLicense.isAttribueEquality()) continue;
                LinkedList<License> licenseList = new LinkedList<License>();
                licenseList.add(license);
                if (!this.removeNotCompatibleShareAlike(shareAlikeInputLicense, licenseList, false).isEmpty()) continue;
                resultingLicenses.remove(license);
            }
        }
        return resultingLicenses;
    }

    protected List<License> removeLessRestrictive(Attributes setting, List<License> licenses, boolean includeMetaAttributes) {
        LinkedList<License> results = new LinkedList<License>();
        List<Attribute> settingAttributes = setting.getList();
        boolean[] settingValues = setting.getValuesArray();
        block0: for (License license : licenses) {
            boolean[] licenseValues = license.getAttributes().getValuesArray();
            for (int i = 0; i < settingValues.length; ++i) {
                if (!includeMetaAttributes && settingAttributes.get(i).isMetaAttribute()) continue;
                if (settingAttributes.get(i).getType().equals(Permission.TYPE)) {
                    if (settingValues[i] || !licenseValues[i]) continue;
                    continue block0;
                }
                if (settingAttributes.get(i).getType().equals(Prohibition.TYPE)) {
                    if (!settingValues[i] || licenseValues[i]) continue;
                    continue block0;
                }
                if (settingAttributes.get(i).getType().equals(Requirement.TYPE)) {
                    if (!settingValues[i] || licenseValues[i]) continue;
                    continue block0;
                }
                throw new RuntimeException("Unknown type");
            }
            results.add(license);
        }
        return results;
    }

    protected List<License> removeNotCompatibleShareAlike(License shareAlikeLicense, List<License> licenses, boolean includeMetaAttributes) {
        LinkedList<License> results = new LinkedList<License>();
        List<Attribute> settingAttributes = shareAlikeLicense.getAttributes().getList();
        boolean[] settingValues = shareAlikeLicense.getAttributes().getValuesArray();
        short ccVersion = this.extractCreativeCommonsVersion(shareAlikeLicense.getUri());
        block0: for (License license : licenses) {
            short licenseCcVersion;
            boolean[] licenseValues = license.getAttributes().getValuesArray();
            for (int i = 0; i < settingValues.length; ++i) {
                if ((includeMetaAttributes || !settingAttributes.get(i).isMetaAttribute() || settingAttributes.get(i).isTypeAttribueEquality()) && settingValues[i] != licenseValues[i]) continue block0;
            }
            if (ccVersion != -1 && (licenseCcVersion = this.extractCreativeCommonsVersion(license.getUri())) != -1 && ccVersion < licenseCcVersion) continue;
            results.add(license);
        }
        return results;
    }

    private short extractCreativeCommonsVersion(String uri) {
        Pattern pattern = Pattern.compile(".*creativecommons.*(\\d)\\.\\d.*");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.matches()) {
            return Short.parseShort(matcher.group(1));
        }
        return -1;
    }
}

