/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterProcessBinding;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;

public class QueryIterAssignVarValue
extends QueryIterProcessBinding {
    private final Var var;
    private final Node node;
    private final boolean mustBeNewVar;

    public QueryIterAssignVarValue(QueryIterator input, Var var, Node node, ExecutionContext qCxt) {
        this(input, var, node, qCxt, false);
    }

    public QueryIterAssignVarValue(QueryIterator input, Var var, Node node, ExecutionContext qCxt, boolean mustBeNewVar) {
        super(input, qCxt);
        this.var = var;
        this.node = node;
        this.mustBeNewVar = mustBeNewVar;
    }

    @Override
    public Binding accept(Binding binding) {
        if (binding.contains(this.var)) {
            if (this.mustBeNewVar) {
                throw new QueryExecException("Already set: " + this.var);
            }
            Node n2 = binding.get(this.var);
            if (!n2.equals(this.node)) {
                return null;
            }
            return binding;
        }
        return BindingFactory.binding(binding, this.var, this.node);
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Lib.className(this));
        out.print(" ?" + this.var.toString() + " = " + FmtUtils.stringForNode(this.node, cxt));
    }
}

