/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.query.QueryException;

public class QueryExceptionHTTP
extends QueryException {
    public static final int noStatusCode = -1234;
    private int statusCode = -1234;
    private final String responseMessage;
    private String statusLine;
    private String response;
    public static final int NoServer = -404;

    public QueryExceptionHTTP(int responseCode, String responseMessage) {
        super(responseMessage);
        this.statusCode = responseCode;
        this.responseMessage = responseMessage;
    }

    public QueryExceptionHTTP(int responseCode) {
        this.statusCode = responseCode;
        this.responseMessage = null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    public int getResponseCode() {
        return this.getStatusCode();
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponse() {
        return this.response;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public QueryExceptionHTTP(Throwable cause) {
        super(cause);
        this.statusCode = -1234;
        this.responseMessage = null;
    }

    public QueryExceptionHTTP(String msg, Throwable cause) {
        super(msg, cause);
        this.statusCode = -1234;
        this.responseMessage = msg;
    }

    public QueryExceptionHTTP(int responseCode, String message, Throwable cause) {
        this(message, cause);
        this.statusCode = responseCode;
    }

    public QueryExceptionHTTP(int responseCode, String message, HttpException ex) {
        this(responseCode, message, ex.getCause());
        this.statusLine = ex.getStatusLine();
        this.response = ex.getResponse();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpException: ");
        int code = this.getStatusCode();
        if (code != -1234) {
            sb.append(code);
            if (this.getResponseMessage() != null) {
                sb.append(" ");
                sb.append(this.getResponseMessage());
            }
        } else {
            sb.append(this.getCause().toString() + ": " + this.getMessage());
        }
        return sb.toString();
    }
}

