/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.Objects;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpFind
extends Op0 {
    private final Triple triple;
    private final Var var;

    public OpFind(Triple triple, Var var) {
        this.triple = triple;
        this.var = var;
    }

    @Override
    public String getName() {
        return "find";
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public Op0 copy() {
        OpFind op = new OpFind(this.triple, this.var);
        return op;
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Triple getTriple() {
        return this.triple;
    }

    public Var getVar() {
        return this.var;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof OpFind)) {
            return false;
        }
        OpFind opFind = (OpFind)other;
        if (!Objects.equals(this.getVar(), opFind.getVar())) {
            return false;
        }
        return Iso.tripleIso(this.getTriple(), opFind.getTriple(), labelMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.triple, this.var);
    }
}

