/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.extra;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.lang.ParserBase;
import org.apache.jena.ttl.JenaURIException;
import org.apache.jena.vocabulary.RDF;

public class TurtleParserBase
extends ParserBase {
    protected final Node XSD_TRUE = NodeConst.nodeTrue;
    protected final Node XSD_FALSE = NodeConst.nodeFalse;
    protected final Node nRDFtype = NodeConst.nodeRDFType;
    protected final Node nRDFnil = NodeConst.nodeNil;
    protected final Node nRDFfirst = NodeConst.nodeFirst;
    protected final Node nRDFrest = NodeConst.nodeRest;
    protected final Node nRDFsubject = RDF.Nodes.subject;
    protected final Node nRDFpredicate = RDF.Nodes.predicate;
    protected final Node nRDFobject = RDF.Nodes.object;
    private StreamRDF stream;
    private ParserProfile profile;

    private static void setErrorWarning(IRIFactory factory, int code, boolean isError, boolean isWarning) {
        factory.setIsWarning(code, isWarning);
        factory.setIsError(code, isError);
    }

    public TurtleParserBase() {
        this.setPrologue(new Prologue());
        IRIFactory iriFactory = new IRIFactory(IRIFactory.iriImplementation());
        TurtleParserBase.setErrorWarning(iriFactory, 4, true, true);
        TurtleParserBase.setErrorWarning(iriFactory, 17, true, true);
        TurtleParserBase.setErrorWarning(iriFactory, 44, false, false);
        TurtleParserBase.setErrorWarning(iriFactory, 49, false, false);
        IRI iri = iriFactory.create(IRIResolver.chooseBaseURI());
        IRIResolver resolver = IRIResolver.create(iri);
        this.getPrologue().setResolver(IRIResolver.create(iri));
    }

    @Override
    public void setPrologue(Prologue prologue) {
        super.setPrologue(prologue);
    }

    @Override
    public Prologue getPrologue() {
        return super.getPrologue();
    }

    @Override
    protected String fixupPrefix(String image, int line, int column) {
        return super.fixupPrefix(image, line, column);
    }

    @Override
    protected Node createNode(String iri) {
        return super.createNode(iri);
    }

    @Override
    protected Node createBNode(int line, int column) {
        return super.createBNode(line, column);
    }

    @Override
    protected Node createBNode(String label, int line, int column) {
        return super.createBNode(label, line, column);
    }

    @Override
    protected Node createListNode(int line, int column) {
        return super.createListNode(line, column);
    }

    @Override
    protected Node createLiteral(String lex, String lang, String uri) {
        return super.createLiteral(lex, lang, uri);
    }

    public static String stripChars(String image, int n) {
        return ParserBase.stripChars(image, n);
    }

    @Override
    protected Node createLiteralInteger(String lexicalForm) {
        return super.createLiteralInteger(lexicalForm);
    }

    @Override
    protected Node createLiteralDecimal(String lexicalForm) {
        return super.createLiteralDecimal(lexicalForm);
    }

    @Override
    protected Node createLiteralDouble(String lexicalForm) {
        return super.createLiteralDouble(lexicalForm);
    }

    public static String unescapeStr(String lex, int line, int column) {
        return ParserBase.unescapeStr(lex, line, column);
    }

    public static String stripQuotes3(String string) {
        return ParserBase.stripQuotes3(string);
    }

    public static String stripQuotes(String string) {
        return ParserBase.stripQuotes(string);
    }

    @Override
    protected String resolvePName(String pname, int line, int column) {
        return super.resolvePName(pname, line, column);
    }

    @Override
    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = TurtleParserBase.stripQuotes(iriStr);
        iriStr = this.unescapeIRI(iriStr);
        try {
            IRIResolver resolver = this.getPrologue().getResolver();
            IRI iRI = resolver.resolve(iriStr);
        }
        catch (JenaURIException ex) {
            throw new RiotParseException(ex.getMessage(), line, column);
        }
        if (iriStr.contains("<") || iriStr.contains(">")) {
            throw new RiotParseException("Illegal character '<' or '>' in IRI: '" + iriStr + "'", line, column);
        }
        return this.getPrologue().getResolver().resolveToString(iriStr);
    }

    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public void setDest(StreamRDF stream) {
        this.stream = stream;
    }

    @Override
    public void setBase(String iri, int line, int column) {
        super.setBase(iri, line, column);
        this.stream.base(iri);
    }

    @Override
    public void setPrefix(String prefix, String iri, int line, int column) {
        prefix = this.fixupPrefix(prefix, line, column);
        super.setPrefix(prefix, iri, line, column);
        this.stream.prefix(prefix, iri);
    }

    public void emitTriple(int line, int column, Node s, Node p, Node o) {
        this.stream.triple(Triple.create(s, p, o));
    }

    private String unescapeIRI(String iriStr) {
        try {
            return EscapeStr.unescape(iriStr, '\\', true);
        }
        catch (AtlasException ex) {
            throw new RiotException(ex.getMessage());
        }
    }

    public void checkIRI(String iriStr) {
    }

    public void listStart(int line, int column) {
    }

    public void listTriple(int line, int column, Node s, Node p, Node o) {
        this.emitTriple(line, column, s, p, o);
    }

    public void listFinish(int line, int column) {
    }
}

