/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.lang.PipedQuadsStream;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedTriplesStream;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.riot.writer.NQuadsWriter;
import org.apache.jena.riot.writer.NTriplesWriter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDataMgr {
    static Logger log;
    @Deprecated
    public static Symbol streamManagerSymbol;

    public static void read(Model model, String uri) {
        RDFDataMgr.read(model.getGraph(), uri);
    }

    public static void read(Graph graph, String uri) {
        RDFDataMgr.read(graph, uri, RDFDataMgr.defaultBase(uri), RDFDataMgr.defaultLang(uri), (Context)null);
    }

    public static void read(Model model, String uri, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, hintLang);
    }

    public static void read(Graph graph, String uri, Lang hintLang) {
        RDFDataMgr.read(graph, uri, hintLang, (Context)null);
    }

    public static void read(Model model, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang);
    }

    public static void read(Graph graph, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(graph, uri, base, hintLang, (Context)null);
    }

    @Deprecated
    public static void read(Model model, String uri, Context context2) {
        RDFDataMgr.read(model.getGraph(), uri, context2);
    }

    @Deprecated
    public static void read(Graph graph, String uri, Context context2) {
        RDFDataMgr.read(graph, uri, RDFDataMgr.defaultLang(uri), context2);
    }

    @Deprecated
    public static void read(Model model, String uri, Lang hintLang, Context context2) {
        RDFDataMgr.read(model, uri, RDFDataMgr.defaultBase(uri), hintLang, context2);
    }

    @Deprecated
    public static void read(Graph graph, String uri, Lang hintLang, Context context2) {
        RDFDataMgr.read(graph, uri, RDFDataMgr.defaultBase(uri), hintLang, context2);
    }

    @Deprecated
    public static void read(Model model, String uri, String base, Lang hintLang, Context context2) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang, context2);
    }

    @Deprecated
    public static void read(Graph graph, String uri, String base, Lang hintLang, Context context2) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parseFromURI(dest, uri, base, hintLang, context2);
    }

    public static void read(Model model, InputStream in, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, lang);
    }

    public static void read(Graph graph, InputStream in, Lang lang) {
        RDFDataMgr.read(graph, in, RDFDataMgr.defaultBase(), lang);
    }

    public static void read(Model model, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    public static void read(Graph graph, InputStream in, String base, Lang lang) {
        Objects.requireNonNull(in, "InputStream is null");
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parseFromInputStream(dest, in, base, lang, null);
    }

    @Deprecated
    public static void read(Model model, Reader in, String base, Lang lang) {
        Objects.requireNonNull(in, "Reader is null");
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(Graph graph, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parseFromReader(dest, in, base, lang, null);
    }

    public static void read(Model model, StringReader in, String base, Lang lang) {
        Graph g = model.getGraph();
        StreamRDF dest = StreamRDFLib.graph(g);
        RDFDataMgr.parseFromReader(dest, in, base, lang, null);
    }

    public static void read(Graph graph, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parseFromReader(dest, in, base, lang, null);
    }

    private static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    private static Graph createGraph() {
        return GraphFactory.createDefaultGraph();
    }

    private static Dataset createDataset() {
        return DatasetFactory.createTxnMem();
    }

    private static DatasetGraph createDatasetGraph() {
        return DatasetGraphFactory.createTxnMem();
    }

    public static Model loadModel(String uri) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri);
        return m;
    }

    public static Model loadModel(String uri, Lang lang) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri, lang);
        return m;
    }

    public static Graph loadGraph(String uri) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri);
        return g;
    }

    public static Graph loadGraph(String uri, Lang lang) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri, lang);
        return g;
    }

    public static Dataset loadDataset(String uri) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static Dataset loadDataset(String uri, Lang lang) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri, Lang lang) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static void read(Dataset dataset, String uri) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri);
    }

    public static void read(DatasetGraph dataset, String uri) {
        RDFDataMgr.read(dataset, uri, RDFDataMgr.defaultLang(uri));
    }

    public static void read(Dataset dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang);
    }

    public static void read(DatasetGraph dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset, uri, hintLang, (Context)null);
    }

    public static void read(Dataset dataset, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, base, hintLang);
    }

    public static void read(DatasetGraph dataset, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(dataset, uri, base, hintLang, (Context)null);
    }

    @Deprecated
    public static void read(Dataset dataset, String uri, Lang hintLang, Context context2) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang, context2);
    }

    @Deprecated
    public static void read(DatasetGraph dataset, String uri, Lang hintLang, Context context2) {
        RDFDataMgr.read(dataset, uri, RDFDataMgr.defaultBase(uri), hintLang, context2);
    }

    @Deprecated
    public static void read(Dataset dataset, String uri, String base, Lang hintLang, Context context2) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, RDFDataMgr.defaultBase(uri), hintLang, context2);
    }

    @Deprecated
    public static void read(DatasetGraph dataset, String uri, String base, Lang hintLang, Context context2) {
        StreamRDF sink = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parseFromURI(sink, uri, base, hintLang, context2);
    }

    public static void read(Dataset dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset, in, RDFDataMgr.defaultBase(), lang);
    }

    public static void read(Dataset dataset, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, String base, Lang lang) {
        Objects.requireNonNull(in, "InputStream is null");
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parseFromInputStream(dest, in, base, lang, null);
    }

    @Deprecated
    public static void read(Dataset dataset, Reader in, String base, Lang lang) {
        Objects.requireNonNull(in, "Java Reader is null");
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(DatasetGraph dataset, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parseFromReader(dest, in, base, lang, null);
    }

    public static void read(Dataset dataset, StringReader in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parseFromReader(dest, in, base, lang, null);
    }

    public static void parse(StreamRDF sink, String uri) {
        RDFDataMgr.parse(sink, uri, RDFDataMgr.defaultLang(uri));
    }

    public static void parse(StreamRDF sink, String uri, Lang lang) {
        RDFDataMgr.parse(sink, uri, lang, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, String uri, Lang hintLang, Context context2) {
        RDFDataMgr.parse(sink, uri, RDFDataMgr.defaultBase(uri), hintLang, context2);
    }

    @Deprecated
    public static void parse(StreamRDF sink, String uri, String base, Lang hintLang) {
        RDFDataMgr.parse(sink, uri, base, hintLang, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, String uri, String base, Lang hintLang, Context context2) {
        if (uri == null) {
            throw new IllegalArgumentException("URI to read from is null");
        }
        if (base == null) {
            base = SysRIOT.chooseBaseIRI(uri);
        }
        if (hintLang == null) {
            hintLang = RDFLanguages.pathnameToLang(uri);
        }
        RDFDataMgr.parseFromURI(sink, uri, base, hintLang, context2);
    }

    public static void parse(StreamRDF sink, InputStream in, Lang lang) {
        RDFDataMgr.parseFromInputStream(sink, in, RDFDataMgr.defaultBase(), lang, null);
    }

    public static void parse(StreamRDF sink, InputStream in, String base, Lang hintLang) {
        RDFDataMgr.parseFromInputStream(sink, in, base, hintLang, null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, InputStream in, String base, Lang hintLang, Context context2) {
        RDFDataMgr.parseFromInputStream(sink, in, base, hintLang, context2);
    }

    public static void parse(StreamRDF sink, StringReader in, Lang lang) {
        RDFDataMgr.parse(sink, in, RDFDataMgr.defaultBase(), lang, (Context)null);
    }

    public static void parse(StreamRDF sink, StringReader in, String base, Lang hintLang) {
        RDFDataMgr.parse(sink, in, base, hintLang, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, StringReader in, String base, Lang hintLang, Context context2) {
        RDFDataMgr.parseFromReader(sink, in, base, hintLang, context2);
    }

    @Deprecated
    public static void parse(StreamRDF sink, Reader in, Lang lang) {
        RDFDataMgr.parse(sink, in, RDFDataMgr.defaultBase(), lang, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, Reader in, String base, Lang hintLang) {
        RDFDataMgr.parse(sink, in, base, hintLang, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, Reader in, String base, Lang hintLang, Context context2) {
        RDFDataMgr.parseFromReader(sink, in, base, hintLang, context2);
    }

    @Deprecated
    public static void parse(StreamRDF sink, TypedInputStream in) {
        RDFDataMgr.parse(sink, in, RDFDataMgr.defaultBase());
    }

    @Deprecated
    public static void parse(StreamRDF sink, TypedInputStream in, String base) {
        RDFDataMgr.parse(sink, in, base, (Context)null);
    }

    @Deprecated
    public static void parse(StreamRDF sink, TypedInputStream in, String base, Context context2) {
        Objects.requireNonNull(in, "TypedInputStream is null");
        Lang hintLang = RDFLanguages.contentTypeToLang(in.getMediaType());
        RDFDataMgr.processFromTypedInputStream(sink, in, base, hintLang, context2);
    }

    public static TypedInputStream open(String filenameOrURI) {
        return RDFDataMgr.open(filenameOrURI, (Context)null);
    }

    public static TypedInputStream open(String filenameOrURI, Context context2) {
        StreamManager sMgr = StreamManager.get(context2);
        return RDFDataMgr.open(filenameOrURI, sMgr);
    }

    public static TypedInputStream open(String filenameOrURI, StreamManager streamManager) {
        TypedInputStream in = streamManager.open(filenameOrURI);
        if (in == null) {
            throw new RiotNotFoundException("Not found: " + filenameOrURI);
        }
        return in;
    }

    private static void parseFromInputStream(StreamRDF destination, InputStream in, String baseUri, Lang lang, Context context2) {
        RDFParser.create().source(in).base(baseUri).lang(lang).context(context2).parse(destination);
    }

    private static void parseFromReader(StreamRDF destination, Reader in, String baseUri, Lang lang, Context context2) {
        RDFParser.create().source(in).base(baseUri).lang(lang).context(context2).parse(destination);
    }

    private static void parseFromURI(StreamRDF destination, String uri, String baseUri, Lang lang, Context context2) {
        RDFParser.create().source(uri).base(baseUri).lang(lang).context(context2).parse(destination);
    }

    @Deprecated
    private static void processFromTypedInputStream(StreamRDF sink, TypedInputStream in, String baseUri, Lang hintLang, Context context2) {
        if (in.getContentType() != null) {
            Lang lang2;
            ContentType ct = WebContent.determineCT(in.getContentType(), hintLang, null);
            hintLang = lang2 = RDFLanguages.contentTypeToLang(ct);
        }
        RDFParser.create().source(in).base(baseUri).lang(hintLang).forceLang(hintLang).context(context2).parse(sink);
    }

    @Deprecated
    public static ReaderRIOT createReader(Lang lang) {
        return RDFDataMgr.createReader(lang, RiotLib.profile(lang, null));
    }

    @Deprecated
    public static ReaderRIOT createReader(Lang lang, ParserProfile profile) {
        Objects.requireNonNull(lang, "Argument lang can not be null in RDFDataMgr.createReader");
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        return r.create(lang, profile);
    }

    private static String defaultBase() {
        return null;
    }

    private static String defaultBase(String uri) {
        return uri;
    }

    private static Lang defaultLang(String uri) {
        return null;
    }

    private static RDFFormat langToFormatOrException(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        if (serialization == null) {
            throw new RiotException("No output format for " + lang);
        }
        return serialization;
    }

    public static Lang determineLang(String target, String ctStr, Lang hintLang) {
        ContentType ct = WebContent.determineCT(ctStr, hintLang, target);
        if (ct == null) {
            return hintLang;
        }
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (lang == null) {
            return hintLang;
        }
        return lang;
    }

    public static void write(OutputStream out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    public static void write(OutputStream out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    public static void write(StringWriter out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    @Deprecated
    public static void write(Writer out, Model model, Lang lang) {
        RDFDataMgr.write(out, model.getGraph(), lang);
    }

    public static void write(StringWriter out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    @Deprecated
    public static void write(Writer out, Model model, RDFFormat serialization) {
        RDFDataMgr.write(out, model.getGraph(), serialization);
    }

    public static void write(OutputStream out, Graph graph, Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        RDFDataMgr.write(out, graph, serialization);
    }

    public static void write(OutputStream out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$(out, graph, serialization);
    }

    public static void write(StringWriter out, Graph graph, Lang lang) {
        RDFDataMgr.write$((Writer)out, graph, RDFDataMgr.langToFormatOrException(lang));
    }

    @Deprecated
    public static void write(Writer out, Graph graph, Lang lang) {
        RDFDataMgr.write$(out, graph, RDFDataMgr.langToFormatOrException(lang));
    }

    public static void write(StringWriter out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, graph, serialization);
    }

    @Deprecated
    public static void write(Writer out, Graph graph, RDFFormat serialization) {
        RDFDataMgr.write$(out, graph, serialization);
    }

    public static void write(OutputStream out, Dataset dataset, Lang lang) {
        RDFDataMgr.write(out, dataset.asDatasetGraph(), lang);
    }

    public static void write(OutputStream out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write(out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(StringWriter out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(StringWriter out, Dataset dataset, Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        RDFDataMgr.write$((Writer)out, dataset.asDatasetGraph(), serialization);
    }

    @Deprecated
    public static void write(Writer out, Dataset dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset.asDatasetGraph(), serialization);
    }

    public static void write(OutputStream out, DatasetGraph dataset, Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        RDFDataMgr.write(out, dataset, serialization);
    }

    public static void write(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset, serialization);
    }

    public static void write(StringWriter out, DatasetGraph dataset, Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        RDFDataMgr.write(out, dataset, serialization);
    }

    public static void write(StringWriter out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$((Writer)out, dataset, serialization);
    }

    @Deprecated
    public static void write(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        RDFDataMgr.write$(out, dataset, serialization);
    }

    public static void writeTriples(OutputStream out, Iterator<Triple> iterator) {
        NTriplesWriter.write(out, iterator);
    }

    public static void writeQuads(OutputStream out, Iterator<Quad> iterator) {
        NQuadsWriter.write(out, iterator);
    }

    @Deprecated
    public static WriterGraphRIOT createGraphWriter(Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        return RDFDataMgr.createGraphWriter$(serialization);
    }

    @Deprecated
    public static WriterGraphRIOT createGraphWriter(RDFFormat serialization) {
        return RDFDataMgr.createGraphWriter$(serialization);
    }

    @Deprecated
    public static WriterDatasetRIOT createDatasetWriter(Lang lang) {
        RDFFormat serialization = RDFDataMgr.langToFormatOrException(lang);
        return RDFDataMgr.createDatasetWriter$(serialization);
    }

    @Deprecated
    public static WriterDatasetRIOT createDatasetWriter(RDFFormat serialization) {
        return RDFDataMgr.createDatasetWriter$(serialization);
    }

    private static WriterGraphRIOT createGraphWriter$(RDFFormat serialization) {
        WriterGraphRIOTFactory wf = RDFWriterRegistry.getWriterGraphFactory(serialization);
        if (wf == null) {
            throw new RiotException("No graph writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private static WriterDatasetRIOT createDatasetWriter$(RDFFormat serialization) {
        WriterDatasetRIOTFactory wf = RDFWriterRegistry.getWriterDatasetFactory(serialization);
        if (wf == null) {
            throw new RiotException("No dataset writer for " + serialization);
        }
        return wf.create(serialization);
    }

    private static void write$(OutputStream out, Graph graph, RDFFormat serialization) {
        RDFWriter.create().format(serialization).source(graph).output(out);
    }

    private static void write$(Writer out, Graph graph, RDFFormat serialization) {
        RDFWriter.create().format(serialization).source(graph).build().output(out);
    }

    private static void write$(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        RDFWriter.create().format(serialization).source(dataset).output(out);
    }

    private static void write$(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        RDFWriter.create().format(serialization).source(dataset).build().output(out);
    }

    public static Iterator<Triple> createIteratorTriples(InputStream input, Lang lang, String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return new IteratorResourceClosing<Triple>(RiotParsers.createIteratorNTriples(input, null), input);
        }
        PipedRDFIterator<Triple> it = new PipedRDFIterator<Triple>();
        PipedTriplesStream out = new PipedTriplesStream(it);
        Thread t = new Thread(() -> RDFDataMgr.parseFromInputStream(out, input, baseIRI, lang, null));
        t.start();
        return it;
    }

    public static Iterator<Quad> createIteratorQuads(InputStream input, Lang lang, String baseIRI) {
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return new IteratorResourceClosing<Quad>(RiotParsers.createIteratorNQuads(input, null, RiotLib.dftProfile()), input);
        }
        PipedRDFIterator<Quad> it = new PipedRDFIterator<Quad>();
        PipedQuadsStream out = new PipedQuadsStream(it);
        Thread t = new Thread(() -> RDFDataMgr.parseFromInputStream(out, input, baseIRI, lang, null));
        t.start();
        return it;
    }

    static {
        JenaSystem.init();
        log = LoggerFactory.getLogger(RDFDataMgr.class);
        streamManagerSymbol = SysRIOT.sysStreamManager;
    }
}

