/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class ListEqual
extends BaseBuiltin {
    @Override
    public String getName() {
        return "listEqual";
    }

    @Override
    public int getArgLength() {
        return 2;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context2) {
        this.checkArgs(length, context2);
        Node n0 = this.getArg(0, args, context2);
        Node n1 = this.getArg(1, args, context2);
        return ListEqual.listEqual(n0, n1, context2);
    }

    protected static boolean listEqual(Node list1, Node list2, RuleContext context2) {
        List<Node> elts1 = Util.convertList(list1, context2);
        List<Node> elts2 = Util.convertList(list2, context2);
        if (elts1.size() != elts2.size()) {
            return false;
        }
        for (Node elt : elts1) {
            boolean matched = false;
            Iterator<Node> j = elts2.iterator();
            while (j.hasNext()) {
                Node elt2 = j.next();
                if (!elt.sameValueAs(elt2)) continue;
                j.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

