/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryExecutionBase;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionBuilder {
    private DatasetGraph dataset = null;
    private Query query = null;
    private Context context = null;
    private Binding binding = null;

    public static QueryExecutionBuilder create() {
        return new QueryExecutionBuilder();
    }

    private QueryExecutionBuilder() {
    }

    public QueryExecutionBuilder query(Query query) {
        this.query = query;
        return this;
    }

    public QueryExecutionBuilder query(String queryString) {
        this.query = QueryFactory.create(queryString);
        return this;
    }

    public QueryExecutionBuilder dataset(DatasetGraph dsg) {
        this.dataset = dsg;
        return this;
    }

    public QueryExecutionBuilder graph(Graph graph) {
        this.dataset = DatasetGraphOne.create(graph);
        return this;
    }

    public QueryExecutionBuilder context(Context context2) {
        this.context = context2;
        return this;
    }

    public QueryExecutionBuilder initialBinding(Binding binding) {
        this.binding = binding;
        return this;
    }

    public QueryExecution build() {
        Context cxt;
        Objects.requireNonNull(this.query, "Query for QueryExecution");
        this.query.setResultVars();
        if (this.context == null) {
            cxt = ARQ.getContext();
            cxt = Context.setupContextForDataset(cxt, this.dataset);
        } else {
            cxt = this.context.copy();
        }
        QueryEngineFactory f = QueryEngineRegistry.get().find(this.query, this.dataset, cxt);
        if (f == null) {
            Log.warn(QueryExecutionBuilder.class, "Failed to find a QueryEngineFactory");
            return null;
        }
        QueryExecutionBase qExec = new QueryExecutionBase(this.query, this.dataset, cxt, f);
        if (this.binding != null) {
            qExec.setInitialBinding(this.binding);
        }
        return qExec;
    }
}

