/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.cc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class CcMatrix {
    private static final String PREFIX = "http://creativecommons.org/";
    public static final String I0_MARK = "http://creativecommons.org/publicdomain/mark/1.0/";
    public static final String I1_ZERO = "http://creativecommons.org/publicdomain/zero/1.0/";
    public static final String I2_BY = "http://creativecommons.org/licenses/by/4.0/";
    public static final String I3_BY_SA = "http://creativecommons.org/licenses/by-sa/4.0/";
    public static final String I4_BY_NC = "http://creativecommons.org/licenses/by-nc/4.0/";
    public static final String I5_BY_ND = "http://creativecommons.org/licenses/by-nd/4.0/";
    public static final String I6_BY_NC_SA = "http://creativecommons.org/licenses/by-nc-sa/4.0/";
    public static final String I7_BY_NC_ND = "http://creativecommons.org/licenses/by-nc-nd/4.0/";
    private int[][] matrix;
    private LinkedHashMap<String, Integer> uriToIndex;

    public static void main(String[] args) {
        System.out.println(new CcMatrix());
    }

    public CcMatrix() {
        this.initialize();
    }

    private void add(int[][] matrix, int index, int ... values) {
        matrix[index] = values;
    }

    public boolean[] getBoolean(String uri) {
        Integer index = this.uriToIndex.get(uri);
        boolean[] array = new boolean[this.matrix.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.matrix[index][i] != 0;
        }
        return array;
    }

    public boolean getBoolean(String uriA, String uriB) {
        return this.getInteger(uriA, uriB) != 0;
    }

    public int[] getInteger(String uri) {
        return this.matrix[this.uriToIndex.get(uri)];
    }

    public int getInteger(String uriA, String uriB) {
        return this.matrix[this.uriToIndex.get(uriA)][this.uriToIndex.get(uriB)];
    }

    public List<String> getUris() {
        return new ArrayList<String>(this.uriToIndex.keySet());
    }

    private void initialize() {
        int index = 0;
        this.uriToIndex = new LinkedHashMap();
        this.uriToIndex.put(I0_MARK, index++);
        this.uriToIndex.put(I1_ZERO, index++);
        this.uriToIndex.put(I2_BY, index++);
        this.uriToIndex.put(I3_BY_SA, index++);
        this.uriToIndex.put(I4_BY_NC, index++);
        this.uriToIndex.put(I5_BY_ND, index++);
        this.uriToIndex.put(I6_BY_NC_SA, index++);
        this.uriToIndex.put(I7_BY_NC_ND, index++);
        index = 0;
        this.matrix = new int[this.uriToIndex.size()][this.uriToIndex.size()];
        this.add(this.matrix, index++, 1, 1, 1, 1, 1, 0, 1, 0);
        this.add(this.matrix, index++, 1, 1, 1, 1, 1, 0, 1, 0);
        this.add(this.matrix, index++, 1, 1, 1, 1, 1, 0, 1, 0);
        this.add(this.matrix, index++, 1, 1, 1, 1, 0, 0, 0, 0);
        this.add(this.matrix, index++, 1, 1, 1, 0, 1, 0, 1, 0);
        this.add(this.matrix, index++, 0, 0, 0, 0, 0, 0, 0, 0);
        this.add(this.matrix, index++, 1, 1, 1, 0, 1, 0, 1, 0);
        this.add(this.matrix, index++, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> uris = this.getUris();
        stringBuilder.append(uris);
        stringBuilder.append(System.lineSeparator());
        for (int i = 0; i < this.matrix.length; ++i) {
            stringBuilder.append(Arrays.toString(this.matrix[i]));
            stringBuilder.append(" ");
            stringBuilder.append(uris.get(i));
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

