/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.io.File;
import org.apache.jena.riot.Lang;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.utils.CcRel;
import org.dice_research.opal.licenses.utils.CollectionUtil;

public class KnowledgeBases {
    public static final String ID_CC = "CreativeCommons";
    public static final String ID_CC_MATRIX = "CreativeCommons-LicenseCompatibilityChart";
    public static final String ID_EDP_LCM = "EuropeanDataPortal-LicenseCompatibilityMatrix";
    public static final File KB_DIRECTORY = new File("src/main/resources/knowledge-bases");
    public static final String KB_FILE_SUFFIX = ".ttl";

    public KnowledgeBase importCreativeCommons() {
        return this.importKnowledgeBase(ID_CC, "http://creativecommons.org/ns#ShareAlike", "http://creativecommons.org/ns#DerivativeWorks");
    }

    public KnowledgeBase importCreativeCommonsMatrix() {
        return this.importKnowledgeBase(ID_CC_MATRIX, "http://creativecommons.org/ns#ShareAlike", "http://creativecommons.org/ns#DerivativeWorks");
    }

    public KnowledgeBase importEDP_Matrix() {
        return this.importKnowledgeBase(ID_EDP_LCM, "http://example.org/Share-Alike", "http://example.org/Derivative-Works");
    }

    private KnowledgeBase importKnowledgeBase(String knowledgeBaseId, String attribueEqualityUri, String permissionOfDerivatesUri) {
        return new CcRel(CollectionUtil.stringToSet(attribueEqualityUri), CollectionUtil.stringToSet(permissionOfDerivatesUri)).importFile(new File(KB_DIRECTORY, knowledgeBaseId + KB_FILE_SUFFIX), Lang.TURTLE);
    }
}

