/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.AttributeFactory;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.Permission;
import org.dice_research.opal.licenses.Prohibition;
import org.dice_research.opal.licenses.Requirement;

public class Odrl {
    public static final String ODRL2 = "http://www.w3.org/ns/odrl/2/";
    public static final Resource R_POLICY = ResourceFactory.createResource("http://www.w3.org/ns/odrl/2/Policy");
    public static final Resource R_RULE_DUTY = ResourceFactory.createResource("http://www.w3.org/ns/odrl/2/Duty");
    public static final Resource R_RULE_PERMISSION = ResourceFactory.createResource("http://www.w3.org/ns/odrl/2/Permission");
    public static final Resource R_RULE_PROHIBITION = ResourceFactory.createResource("http://www.w3.org/ns/odrl/2/Prohibition");
    public static final Property P_OBLIGATION = ResourceFactory.createProperty("http://www.w3.org/ns/odrl/2/obligation");
    public static final Property P_PERMISSION = ResourceFactory.createProperty("http://www.w3.org/ns/odrl/2/permission");
    public static final Property P_PROHIBITION = ResourceFactory.createProperty("http://www.w3.org/ns/odrl/2/prohibition");
    public static final Property P_ACTION = ResourceFactory.createProperty("http://www.w3.org/ns/odrl/2/action");
    public static final String CC = "http://creativecommons.org/ns#";
    public static final Resource R_DERIVATIVE_WORKS = ResourceFactory.createResource("http://creativecommons.org/ns#DerivativeWorks");
    public static final Resource R_SHARE_ALIKE = ResourceFactory.createResource("http://creativecommons.org/ns#ShareAlike");
    private boolean includeMetaAttributes;

    public Odrl() {
        this.includeMetaAttributes = false;
    }

    public Odrl(boolean includeMetaAttributes) {
        this.includeMetaAttributes = includeMetaAttributes;
    }

    public void export(KnowledgeBase kb, File file, Lang lang) {
        Model model = this.export(kb);
        if (lang.equals(Lang.TURTLE)) {
            model.setNsPrefix("cc", CC);
            model.setNsPrefix("odrl", ODRL2);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            RDFDataMgr.write((OutputStream)fos, model, lang);
            fos.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public Model export(KnowledgeBase kb) {
        Model model = ModelFactory.createDefaultModel();
        for (License license : kb.getLicenses()) {
            Resource rLicense = ResourceFactory.createResource(license.getUri());
            model.add(rLicense, RDF.type, R_POLICY);
            if (license.getName() != null && !license.getName().isEmpty()) {
                model.add(rLicense, RDFS.label, ResourceFactory.createPlainLiteral(license.getName()));
            }
            for (Attribute attribute : license.getAttributes().getUriToAttributeMap().values()) {
                if (!attribute.getValue().booleanValue()) continue;
                Resource rAttribute = ResourceFactory.createResource(attribute.getUri());
                if (attribute instanceof Permission) {
                    model.add(rAttribute, RDF.type, R_RULE_PERMISSION);
                    model.add(rLicense, P_PERMISSION, rAttribute);
                } else if (attribute instanceof Prohibition) {
                    model.add(rAttribute, RDF.type, R_RULE_PROHIBITION);
                    model.add(rLicense, P_PROHIBITION, rAttribute);
                } else if (attribute instanceof Requirement) {
                    model.add(rAttribute, RDF.type, R_RULE_DUTY);
                    model.add(rLicense, P_OBLIGATION, rAttribute);
                } else {
                    throw new RuntimeException("Unknown attibute type");
                }
                if (!this.includeMetaAttributes) continue;
                if (attribute.isTypeAttribueEquality()) {
                    model.add(rAttribute, P_ACTION, R_SHARE_ALIKE);
                }
                if (!attribute.isTypePermissionOfDerivates()) continue;
                model.add(rAttribute, P_ACTION, R_DERIVATIVE_WORKS);
            }
        }
        return model;
    }

    public KnowledgeBase importFile(File file, Lang lang) {
        return this.importModel(RDFDataMgr.loadModel(file.toURI().toString(), lang));
    }

    public KnowledgeBase importModel(Model model) {
        Resource rPolicy;
        KnowledgeBase kb = new KnowledgeBase();
        ResIterator policyIt = model.listSubjectsWithProperty(RDF.type, R_POLICY);
        while (policyIt.hasNext()) {
            Attribute attribute;
            Resource rRule;
            RDFNode nRule;
            rPolicy = (Resource)policyIt.next();
            StmtIterator ruleIt = rPolicy.listProperties(P_PERMISSION);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Permission.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
            ruleIt = rPolicy.listProperties(P_PROHIBITION);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Prohibition.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
            ruleIt = rPolicy.listProperties(P_OBLIGATION);
            while (ruleIt.hasNext()) {
                nRule = ((Statement)ruleIt.next()).getObject();
                if (!nRule.isURIResource()) continue;
                rRule = nRule.asResource();
                attribute = AttributeFactory.get().createAttribute(Requirement.TYPE, rRule.getURI());
                if (kb.getSortedAttributes().getUris().contains(attribute.getUri())) continue;
                this.addMetaAttribute(rRule, attribute);
                kb.getSortedAttributes().addAttribute(attribute);
            }
        }
        policyIt = model.listSubjectsWithProperty(RDF.type, R_POLICY);
        while (policyIt.hasNext()) {
            rPolicy = (Resource)policyIt.next();
            License license = new License();
            license.setUri(rPolicy.getURI());
            Statement stmt = rPolicy.getProperty(RDFS.label);
            if (stmt != null) {
                license.setName(stmt.getObject().asLiteral().getString());
            }
            Attributes attributes = new Attributes();
            for (Attribute attribute : kb.getSortedAttributes().getList()) {
                attributes.addAttribute(AttributeFactory.get().createAttribute(attribute, false).setValue(false));
            }
            license.setAttributes(attributes);
            this.updateAttributes(rPolicy, P_PERMISSION, attributes);
            this.updateAttributes(rPolicy, P_PROHIBITION, attributes);
            this.updateAttributes(rPolicy, P_OBLIGATION, attributes);
            kb.addLicense(license);
        }
        for (License license : kb.getLicenses()) {
            for (Attribute attribute : kb.getSortedAttributes().getList()) {
                if (license.getAttributes().getUris().contains(attribute.getUri())) continue;
                license.getAttributes().addAttribute(AttributeFactory.get().createAttribute(attribute, false).setValue(false));
            }
        }
        return kb;
    }

    private void updateAttributes(Resource rPolicy, Property pRule, Attributes attributes) {
        StmtIterator ruleIt = rPolicy.listProperties(pRule);
        while (ruleIt.hasNext()) {
            RDFNode nRule = ((Statement)ruleIt.next()).getObject();
            if (!nRule.isURIResource()) continue;
            Resource rRule = nRule.asResource();
            attributes.getAttribute(rRule.getURI()).setValue(true);
        }
    }

    private void addMetaAttribute(Resource rRule, Attribute attribute) {
        RDFNode nAction;
        Statement stmt;
        if (this.includeMetaAttributes && (stmt = rRule.getProperty(P_ACTION)) != null && (nAction = stmt.getObject()).isURIResource()) {
            String actionUri = nAction.asResource().getURI();
            if (actionUri.equals(R_SHARE_ALIKE.getURI())) {
                attribute.setTypeAttribueEquality(true);
            } else if (actionUri.equals(R_DERIVATIVE_WORKS.getURI())) {
                attribute.setTypePermissionOfDerivates(true);
            }
        }
    }
}

