/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.utils;

public class F1Score {
    private long falseNegative = 0L;
    private long falsePositive = 0L;
    private long trueNegative = 0L;
    private long truePositive = 0L;

    public F1Score falseNegative() {
        ++this.falseNegative;
        return this;
    }

    public F1Score falsePositive() {
        ++this.falsePositive;
        return this;
    }

    public long getAll() {
        return this.falseNegative + this.falsePositive + this.trueNegative + this.truePositive;
    }

    public double getF1score() {
        double precision = this.getPrecision();
        double recall = this.getRecall();
        if (precision == 0.0 && recall == 0.0) {
            return 0.0;
        }
        return 2.0 * (precision * recall / (precision + recall));
    }

    public long getFalse() {
        return this.falseNegative + this.falsePositive;
    }

    public long getFalseNegative() {
        return this.falseNegative;
    }

    public long getFalsePositive() {
        return this.falsePositive;
    }

    public long getNegative() {
        return this.falseNegative + this.trueNegative;
    }

    public double getPercentageFalse() {
        return 1.0 * (double)this.getFalse() / (double)this.getAll();
    }

    public double getPercentageNegative() {
        return 1.0 * (double)this.getNegative() / (double)this.getAll();
    }

    public double getPercentagePositive() {
        return 1.0 * (double)this.getPositive() / (double)this.getAll();
    }

    public double getPercentageTrue() {
        return 1.0 * (double)this.getTrue() / (double)this.getAll();
    }

    public long getPositive() {
        return this.falsePositive + this.truePositive;
    }

    public double getPrecision() {
        float precisionDenomiator = this.truePositive + this.falsePositive;
        if ((double)precisionDenomiator == 0.0) {
            return 1.0;
        }
        return (float)this.truePositive / precisionDenomiator;
    }

    public double getRecall() {
        float recallDenominator = this.truePositive + this.falseNegative;
        if ((double)recallDenominator == 0.0) {
            return 1.0;
        }
        return (float)this.truePositive / recallDenominator;
    }

    public long getTrue() {
        return this.trueNegative + this.truePositive;
    }

    public long getTrueNegative() {
        return this.trueNegative;
    }

    public long getTruePositive() {
        return this.truePositive;
    }

    public F1Score trueNegative() {
        ++this.trueNegative;
        return this;
    }

    public F1Score truePositive() {
        ++this.truePositive;
        return this;
    }
}

